/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberGatewayHub")
@Scope(value="singleton")
public class MemberGatewayHubService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberGatewayHub").get("memberName").textValue();
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName(memberName));
        if (clusterMember != null) {
            Cluster.GatewayReceiver gatewayReceiver = clusterMember.getGatewayReceiver();
            Boolean isGateway = false;
            if (gatewayReceiver != null) {
                responseJSON.put("isGatewayReceiver", true);
                responseJSON.put("listeningPort", gatewayReceiver.getListeningPort());
                responseJSON.put("linkTroughput", gatewayReceiver.getLinkThroughput());
                responseJSON.put("avgBatchLatency", gatewayReceiver.getAvgBatchProcessingTime());
            } else {
                responseJSON.put("isGatewayReceiver", false);
            }
            Cluster.GatewaySender[] gatewaySenders = clusterMember.getMemberGatewaySenders();
            if (gatewaySenders.length > 0) {
                isGateway = true;
            }
            responseJSON.put("isGatewaySender", isGateway);
            ArrayNode gatewaySendersJsonList = this.mapper.createArrayNode();
            for (Cluster.GatewaySender gatewaySender : gatewaySenders) {
                ObjectNode gatewaySenderJSON = this.mapper.createObjectNode();
                gatewaySenderJSON.put("id", gatewaySender.getId());
                gatewaySenderJSON.put("queueSize", gatewaySender.getQueueSize());
                gatewaySenderJSON.put("status", gatewaySender.getStatus());
                gatewaySenderJSON.put("primary", gatewaySender.getPrimary());
                gatewaySenderJSON.put("senderType", gatewaySender.getSenderType());
                gatewaySenderJSON.put("batchSize", gatewaySender.getBatchSize());
                gatewaySenderJSON.put("PersistenceEnabled", gatewaySender.getPersistenceEnabled());
                gatewaySenderJSON.put("remoteDSId", gatewaySender.getRemoteDSId());
                gatewaySenderJSON.put("eventsExceedingAlertThreshold", gatewaySender.getEventsExceedingAlertThreshold());
                gatewaySendersJsonList.add((JsonNode)gatewaySenderJSON);
            }
            responseJSON.put("gatewaySenders", (JsonNode)gatewaySendersJsonList);
            Cluster.AsyncEventQueue[] asyncEventQueues = clusterMember.getMemberAsyncEventQueueList();
            ArrayNode asyncEventQueueJsonList = this.mapper.createArrayNode();
            for (Cluster.AsyncEventQueue asyncEventQueue : asyncEventQueues) {
                ObjectNode asyncEventQueueJSON = this.mapper.createObjectNode();
                asyncEventQueueJSON.put("id", asyncEventQueue.getId());
                asyncEventQueueJSON.put("primary", asyncEventQueue.getPrimary());
                asyncEventQueueJSON.put("senderType", asyncEventQueue.isParallel());
                asyncEventQueueJSON.put("batchSize", asyncEventQueue.getBatchSize());
                asyncEventQueueJSON.put("batchTimeInterval", asyncEventQueue.getBatchTimeInterval());
                asyncEventQueueJSON.put("batchConflationEnabled", asyncEventQueue.isBatchConflationEnabled());
                asyncEventQueueJSON.put("asyncEventListener", asyncEventQueue.getAsyncEventListener());
                asyncEventQueueJSON.put("queueSize", asyncEventQueue.getEventQueueSize());
                asyncEventQueueJsonList.add((JsonNode)asyncEventQueueJSON);
            }
            responseJSON.put("asyncEventQueues", (JsonNode)asyncEventQueueJsonList);
            Map<String, Cluster.Region> clusterRegions = cluster.getClusterRegions();
            ArrayList<Cluster.Region> clusterRegionsList = new ArrayList<Cluster.Region>();
            clusterRegionsList.addAll(clusterRegions.values());
            ArrayNode regionsList = this.mapper.createArrayNode();
            for (Cluster.Region region : clusterRegionsList) {
                if (!region.getWanEnabled()) continue;
                ObjectNode regionJSON = this.mapper.createObjectNode();
                regionJSON.put("name", region.getName());
                regionsList.add((JsonNode)regionJSON);
            }
            responseJSON.put("regionsInvolved", (JsonNode)regionsList);
        }
        return responseJSON;
    }
}

