/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.utilities;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorAPI;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;

@Experimental
public abstract class ProtobufRequestUtilities {
    public static ClientProtocol.Message createGetRequest(String regionName, BasicTypes.EncodedValue key) {
        RegionAPI.GetRequest getRequest = RegionAPI.GetRequest.newBuilder().setRegionName(regionName).setKey(key).build();
        return ClientProtocol.Message.newBuilder().setGetRequest(getRequest).build();
    }

    public static ClientProtocol.Message createRemoveRequest(String regionName, BasicTypes.EncodedValue key) {
        RegionAPI.RemoveRequest removeRequest = RegionAPI.RemoveRequest.newBuilder().setRegionName(regionName).setKey(key).build();
        return ClientProtocol.Message.newBuilder().setRemoveRequest(removeRequest).build();
    }

    public static RegionAPI.GetRegionNamesRequest createGetRegionNamesRequest() {
        return RegionAPI.GetRegionNamesRequest.newBuilder().build();
    }

    public static ClientProtocol.Message createPutRequest(String region, BasicTypes.Entry entry) {
        RegionAPI.PutRequest putRequest = RegionAPI.PutRequest.newBuilder().setRegionName(region).setEntry(entry).build();
        return ClientProtocol.Message.newBuilder().setPutRequest(putRequest).build();
    }

    public static RegionAPI.GetAllRequest createGetAllRequest(String regionName, Set<BasicTypes.EncodedValue> keys) {
        RegionAPI.GetAllRequest.Builder getAllRequestBuilder = RegionAPI.GetAllRequest.newBuilder().setRegionName(regionName);
        getAllRequestBuilder.addAllKey(keys);
        return getAllRequestBuilder.build();
    }

    public static ClientProtocol.Message createPutAllRequest(String regionName, Set<BasicTypes.Entry> entries) {
        RegionAPI.PutAllRequest.Builder putAllRequestBuilder = RegionAPI.PutAllRequest.newBuilder().setRegionName(regionName);
        putAllRequestBuilder.addAllEntry(entries);
        return ClientProtocol.Message.newBuilder().setPutAllRequest(putAllRequestBuilder).build();
    }

    public static LocatorAPI.GetServerRequest createGetServerRequest() {
        LocatorAPI.GetServerRequest.Builder builder = LocatorAPI.GetServerRequest.newBuilder();
        return builder.build();
    }

    public static LocatorAPI.GetServerRequest createGetServerRequest(String serverGroup) {
        LocatorAPI.GetServerRequest.Builder builder = LocatorAPI.GetServerRequest.newBuilder();
        builder.setServerGroup(serverGroup);
        return builder.build();
    }
}

