/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ProtocolVersionHandler;
import org.apache.geode.internal.protocol.protobuf.v1.state.LegacySecurityProtobufConnectionStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.NoSecurityProtobufConnectionStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.internal.security.SecurityService;

public class ProtobufConnectionHandshakeStateProcessor
implements ProtobufConnectionStateProcessor {
    private final SecurityService securityService;

    public ProtobufConnectionHandshakeStateProcessor(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public void validateOperation(Object message, ProtobufSerializationService serializer, MessageExecutionContext messageContext, ProtobufOperationContext operationContext) throws ConnectionStateException {
        throw new ConnectionStateException(BasicTypes.ErrorCode.INVALID_REQUEST, "Connection processing should never be asked to validate an operation");
    }

    private ProtobufConnectionStateProcessor nextConnectionState() {
        if (this.securityService.isIntegratedSecurity()) {
            return new ProtobufConnectionAuthenticatingStateProcessor(this.securityService);
        }
        if (this.securityService.isPeerSecurityRequired() || this.securityService.isClientSecurityRequired()) {
            return new LegacySecurityProtobufConnectionStateProcessor();
        }
        return new NoSecurityProtobufConnectionStateProcessor();
    }

    @Override
    public boolean handleMessageIndependently(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws IOException {
        PushbackInputStream messageStream = new PushbackInputStream(inputStream);
        messageStream.unread(CommunicationMode.ProtobufClientServerProtocol.getModeNumber());
        if (ProtocolVersionHandler.handleVersionMessage(messageStream, outputStream, executionContext.getStatistics())) {
            executionContext.setConnectionStateProcessor(this.nextConnectionState());
        }
        return true;
    }
}

