/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.state;

import java.util.Properties;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.operations.security.AuthenticationRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionAuthorizingStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.shiro.subject.Subject;

public class ProtobufConnectionAuthenticatingStateProcessor
implements ProtobufConnectionStateProcessor {
    private final SecurityService securityService;

    public ProtobufConnectionAuthenticatingStateProcessor(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public void validateOperation(Object message, ProtobufSerializationService serializer, MessageExecutionContext messageContext, ProtobufOperationContext operationContext) throws ConnectionStateException {
        if (!(operationContext.getOperationHandler() instanceof AuthenticationRequestOperationHandler)) {
            throw new ConnectionStateException(BasicTypes.ErrorCode.AUTHENTICATION_FAILED, "User has not yet authenticated");
        }
    }

    @Override
    public ProtobufConnectionAuthenticatingStateProcessor allowAuthentication() throws ConnectionStateException {
        return this;
    }

    public ProtobufConnectionStateProcessor authenticate(Properties properties) throws AuthenticationFailedException {
        Subject subject = this.securityService.login(properties);
        return new ProtobufConnectionAuthorizingStateProcessor(this.securityService, subject);
    }
}

