/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations.security;

import java.util.Map;
import java.util.Properties;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.ConnectionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionTerminatingStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.logging.log4j.Logger;

public class AuthenticationRequestOperationHandler
implements ProtobufOperationHandler<ConnectionAPI.AuthenticationRequest, ConnectionAPI.AuthenticationResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<ConnectionAPI.AuthenticationResponse> process(ProtobufSerializationService serializationService, ConnectionAPI.AuthenticationRequest request, MessageExecutionContext messageExecutionContext) throws ConnectionStateException {
        ProtobufConnectionAuthenticatingStateProcessor stateProcessor = messageExecutionContext.getConnectionStateProcessor().allowAuthentication();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)request.getCredentialsMap());
        try {
            ProtobufConnectionStateProcessor nextState = stateProcessor.authenticate(properties);
            messageExecutionContext.setConnectionStateProcessor(nextState);
            return Success.of(ConnectionAPI.AuthenticationResponse.newBuilder().setAuthenticated(true).build());
        }
        catch (AuthenticationFailedException e) {
            messageExecutionContext.getStatistics().incAuthenticationFailures();
            logger.debug("Authentication failed", (Throwable)e);
            messageExecutionContext.setConnectionStateProcessor(new ProtobufConnectionTerminatingStateProcessor());
            return Success.of(ConnectionAPI.AuthenticationResponse.newBuilder().setAuthenticated(false).build());
        }
    }
}

