/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;

@Experimental
public class KeySetOperationHandler
implements ProtobufOperationHandler<RegionAPI.KeySetRequest, RegionAPI.KeySetResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.KeySetResponse> process(ProtobufSerializationService serializationService, RegionAPI.KeySetRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, EncodingException, DecodingException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received request for nonexistent region: {}", (Object)regionName);
            return Failure.of(BasicTypes.ErrorCode.SERVER_ERROR, "Region \"" + regionName + "\" not found");
        }
        Set keySet = region.keySet();
        RegionAPI.KeySetResponse.Builder builder = RegionAPI.KeySetResponse.newBuilder();
        keySet.stream().map(serializationService::encode).forEach(value -> builder.addKeys((BasicTypes.EncodedValue)value));
        return Success.of(builder.build());
    }

    public static ResourcePermission determineRequiredPermission(RegionAPI.KeySetRequest request, ProtobufSerializationService serializer) throws DecodingException {
        return new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, request.getRegionName());
    }
}

