/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetRegionRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetRegionRequest, RegionAPI.GetRegionResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.GetRegionResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetRegionRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received GetRegion request for non-existing region {}", (Object)regionName);
            return Failure.of(BasicTypes.ErrorCode.SERVER_ERROR, "No region exists for name: " + regionName);
        }
        BasicTypes.Region protoRegion = ProtobufUtilities.createRegionMessageFromRegion(region);
        return Success.of(RegionAPI.GetRegionResponse.newBuilder().setRegion(protoRegion).build());
    }
}

