/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionAuthorizingStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.util.ThreadState;

@Experimental
public class GetAllRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse> {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<RegionAPI.GetAllResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetAllRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received get-all request for nonexistent region: {}", (Object)regionName);
            return Failure.of(BasicTypes.ErrorCode.SERVER_ERROR, "Region \"" + regionName + "\" not found");
        }
        ThreadState threadState = null;
        SecurityService securityService = messageExecutionContext.getCache().getSecurityService();
        boolean perKeyAuthorization = false;
        if (messageExecutionContext.getConnectionStateProcessor() instanceof ProtobufConnectionAuthorizingStateProcessor) {
            threadState = ((ProtobufConnectionAuthorizingStateProcessor)messageExecutionContext.getConnectionStateProcessor()).prepareThreadForAuthorization();
            try {
                securityService.authorize(new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName));
                ((ProtobufConnectionAuthorizingStateProcessor)messageExecutionContext.getConnectionStateProcessor()).restoreThreadState(threadState);
                threadState = null;
            }
            catch (NotAuthorizedException ex) {
                perKeyAuthorization = true;
            }
        }
        boolean authorizeKeys = perKeyAuthorization;
        long startTime = messageExecutionContext.getStatistics().startOperation();
        RegionAPI.GetAllResponse.Builder responseBuilder = RegionAPI.GetAllResponse.newBuilder();
        try {
            messageExecutionContext.getCache().setReadSerializedForCurrentThread(true);
            request.getKeyList().stream().forEach(key -> this.processSingleKey(responseBuilder, serializationService, region, (BasicTypes.EncodedValue)key, securityService, authorizeKeys));
        }
        finally {
            messageExecutionContext.getCache().setReadSerializedForCurrentThread(false);
            messageExecutionContext.getStatistics().endOperation(startTime);
            if (threadState != null) {
                ((ProtobufConnectionAuthorizingStateProcessor)messageExecutionContext.getConnectionStateProcessor()).restoreThreadState(threadState);
            }
        }
        return Success.of(responseBuilder.build());
    }

    private void processSingleKey(RegionAPI.GetAllResponse.Builder responseBuilder, ProtobufSerializationService serializationService, Region region, BasicTypes.EncodedValue key, SecurityService securityService, boolean authorizeKeys) {
        try {
            Object decodedKey = serializationService.decode(key);
            if (decodedKey == null) {
                responseBuilder.addFailures(this.buildKeyedError(key, "NULL is not a valid key for get.", BasicTypes.ErrorCode.INVALID_REQUEST));
                return;
            }
            if (authorizeKeys) {
                securityService.authorize(new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, region.getName(), decodedKey.toString()));
            }
            Object value = region.get(decodedKey);
            BasicTypes.Entry entry = ProtobufUtilities.createEntry(serializationService, decodedKey, value);
            responseBuilder.addEntries(entry);
        }
        catch (NotAuthorizedException ex) {
            responseBuilder.addFailures(this.buildKeyedError(key, "Unauthorized access", BasicTypes.ErrorCode.AUTHORIZATION_FAILED));
        }
        catch (DecodingException ex) {
            logger.info("Key encoding not supported: {}", (Throwable)ex);
            responseBuilder.addFailures(this.buildKeyedError(key, "Key encoding not supported.", BasicTypes.ErrorCode.INVALID_REQUEST));
        }
        catch (EncodingException ex) {
            logger.info("Value encoding not supported: {}", (Throwable)ex);
            responseBuilder.addFailures(this.buildKeyedError(key, "Value encoding not supported.", BasicTypes.ErrorCode.INVALID_REQUEST));
        }
        catch (Exception ex) {
            logger.warn("Failure in protobuf getAll operation for key: " + key, (Throwable)ex);
            responseBuilder.addFailures(this.buildKeyedError(key, ex.toString(), BasicTypes.ErrorCode.SERVER_ERROR));
        }
    }

    private BasicTypes.KeyedError buildKeyedError(BasicTypes.EncodedValue key, String errorMessage, BasicTypes.ErrorCode errorCode) {
        return BasicTypes.KeyedError.newBuilder().setKey(key).setError(BasicTypes.Error.newBuilder().setErrorCode(errorCode).setMessage(errorMessage)).build();
    }
}

