/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.operations.AbstractFunctionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.logging.log4j.Logger;

public class ExecuteFunctionOnRegionRequestOperationHandler
extends AbstractFunctionRequestOperationHandler<FunctionAPI.ExecuteFunctionOnRegionRequest, FunctionAPI.ExecuteFunctionOnRegionResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    protected Set<Object> parseFilter(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnRegionRequest request) throws DecodingException {
        List encodedFilter = request.getKeyFilterList();
        HashSet<Object> filter = new HashSet<Object>();
        for (BasicTypes.EncodedValue filterKey : encodedFilter) {
            filter.add(serializationService.decode(filterKey));
        }
        return filter;
    }

    @Override
    protected String getFunctionID(FunctionAPI.ExecuteFunctionOnRegionRequest request) {
        return request.getFunctionID();
    }

    @Override
    protected String getRegionName(FunctionAPI.ExecuteFunctionOnRegionRequest request) {
        return request.getRegion();
    }

    @Override
    protected Object getExecutionTarget(FunctionAPI.ExecuteFunctionOnRegionRequest request, String regionName, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        Region region = executionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received execute-function-on-region request for nonexistent region: {}", (Object)regionName);
            return Failure.of(BasicTypes.ErrorCode.SERVER_ERROR, "Region \"" + regionName + "\" not found");
        }
        return region;
    }

    @Override
    protected Object getFunctionArguments(FunctionAPI.ExecuteFunctionOnRegionRequest request, ProtobufSerializationService serializationService) throws DecodingException {
        if (request.hasArguments()) {
            return serializationService.decode(request.getArguments());
        }
        return null;
    }

    @Override
    protected Execution getFunctionExecutionObject(Object executionTarget) {
        return FunctionService.onRegion((Region)((Region)executionTarget));
    }

    @Override
    protected Result buildResultMessage(ProtobufSerializationService serializationService, List<Object> results) throws EncodingException {
        FunctionAPI.ExecuteFunctionOnRegionResponse.Builder responseMessage = FunctionAPI.ExecuteFunctionOnRegionResponse.newBuilder();
        for (Object result : results) {
            responseMessage.addResults(serializationService.encode(result));
        }
        return Success.of(responseMessage.build());
    }

    @Override
    protected Result buildResultMessage(ProtobufSerializationService serializationService) {
        return Success.of(FunctionAPI.ExecuteFunctionOnRegionResponse.newBuilder().build());
    }
}

