/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import com.google.protobuf.ProtocolStringList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.operations.AbstractFunctionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;

public class ExecuteFunctionOnMemberRequestOperationHandler
extends AbstractFunctionRequestOperationHandler<FunctionAPI.ExecuteFunctionOnMemberRequest, FunctionAPI.ExecuteFunctionOnMemberResponse> {
    @Override
    protected Set<?> parseFilter(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnMemberRequest request) throws EncodingException {
        return null;
    }

    @Override
    protected String getFunctionID(FunctionAPI.ExecuteFunctionOnMemberRequest request) {
        return request.getFunctionID();
    }

    @Override
    protected String getRegionName(FunctionAPI.ExecuteFunctionOnMemberRequest request) {
        return null;
    }

    @Override
    protected Object getExecutionTarget(FunctionAPI.ExecuteFunctionOnMemberRequest request, String regionName, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        ProtocolStringList memberNameList = request.getMemberNameList();
        HashSet<DistributedMember> memberIds = new HashSet<DistributedMember>(memberNameList.size());
        DistributionManager distributionManager = executionContext.getCache().getDistributionManager();
        for (String name : memberNameList) {
            DistributedMember member = distributionManager.getMemberWithName(name);
            if (member == null) {
                return Failure.of(BasicTypes.ErrorCode.NO_AVAILABLE_SERVER, "Member " + name + " not found to execute \"" + request.getFunctionID() + "\"");
            }
            memberIds.add(member);
        }
        if (memberIds.isEmpty()) {
            return Failure.of(BasicTypes.ErrorCode.NO_AVAILABLE_SERVER, "No members found to execute \"" + request.getFunctionID() + "\"");
        }
        return memberIds;
    }

    @Override
    protected Object getFunctionArguments(FunctionAPI.ExecuteFunctionOnMemberRequest request, ProtobufSerializationService serializationService) throws DecodingException {
        if (request.hasArguments()) {
            return serializationService.decode(request.getArguments());
        }
        return null;
    }

    @Override
    protected Execution getFunctionExecutionObject(Object executionTarget) {
        Set memberIds = (Set)executionTarget;
        if (memberIds.size() == 1) {
            return FunctionService.onMember((DistributedMember)((DistributedMember)memberIds.iterator().next()));
        }
        return FunctionService.onMembers((Set)memberIds);
    }

    @Override
    protected Result buildResultMessage(ProtobufSerializationService serializationService, List<Object> results) throws EncodingException {
        FunctionAPI.ExecuteFunctionOnMemberResponse.Builder responseMessage = FunctionAPI.ExecuteFunctionOnMemberResponse.newBuilder();
        for (Object result : results) {
            responseMessage.addResults(serializationService.encode(result));
        }
        return Success.of(responseMessage.build());
    }

    @Override
    protected Result buildResultMessage(ProtobufSerializationService serializationService) {
        return Success.of(FunctionAPI.ExecuteFunctionOnMemberResponse.newBuilder().build());
    }
}

