/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import com.google.protobuf.ProtocolStringList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.operations.AbstractFunctionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;

public class ExecuteFunctionOnGroupRequestOperationHandler
extends AbstractFunctionRequestOperationHandler<FunctionAPI.ExecuteFunctionOnGroupRequest, FunctionAPI.ExecuteFunctionOnGroupResponse> {
    @Override
    protected Set<?> parseFilter(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnGroupRequest request) {
        return null;
    }

    @Override
    protected String getFunctionID(FunctionAPI.ExecuteFunctionOnGroupRequest request) {
        return request.getFunctionID();
    }

    @Override
    protected String getRegionName(FunctionAPI.ExecuteFunctionOnGroupRequest request) {
        return null;
    }

    @Override
    protected Object getExecutionTarget(FunctionAPI.ExecuteFunctionOnGroupRequest request, String regionName, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        ProtocolStringList groupList = request.getGroupNameList();
        InternalDistributedSystem distributedSystem = executionContext.getCache().getDistributionManager().getSystem();
        boolean foundMatch = false;
        for (String group : groupList) {
            if (distributedSystem.getGroupMembers(group).size() <= 0) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            return Failure.of(BasicTypes.ErrorCode.NO_AVAILABLE_SERVER, "No server  in groups " + groupList + " could be found to execute \"" + request.getFunctionID() + "\"");
        }
        return groupList;
    }

    @Override
    protected Object getFunctionArguments(FunctionAPI.ExecuteFunctionOnGroupRequest request, ProtobufSerializationService serializationService) throws DecodingException {
        if (request.hasArguments()) {
            return serializationService.decode(request.getArguments());
        }
        return null;
    }

    @Override
    protected Execution getFunctionExecutionObject(Object executionTarget) {
        ProtocolStringList groupList = (ProtocolStringList)executionTarget;
        return FunctionService.onMember((String[])((String[])groupList.toArray((Object[])new String[0])));
    }

    @Override
    protected Result buildResultMessage(ProtobufSerializationService serializationService, List<Object> results) throws EncodingException {
        FunctionAPI.ExecuteFunctionOnGroupResponse.Builder responseMessage = FunctionAPI.ExecuteFunctionOnGroupResponse.newBuilder();
        for (Object result : results) {
            responseMessage.addResults(serializationService.encode(result));
        }
        return Success.of(responseMessage.build());
    }

    @Override
    protected Result buildResultMessage(ProtobufSerializationService serializationService) {
        return Success.of(FunctionAPI.ExecuteFunctionOnGroupResponse.newBuilder().build());
    }
}

