/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionAuthorizingStateProcessor;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.util.ThreadState;

public abstract class AbstractFunctionRequestOperationHandler<Req, Resp>
implements ProtobufOperationHandler<Req, Resp> {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<Resp> process(ProtobufSerializationService serializationService, Req request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException, EncodingException {
        String functionID = this.getFunctionID(request);
        Function function = FunctionService.getFunction((String)functionID);
        if (function == null) {
            return Failure.of(BasicTypes.ErrorCode.INVALID_REQUEST, LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(new Object[]{functionID}));
        }
        SecurityService securityService = messageExecutionContext.getCache().getSecurityService();
        String regionName = this.getRegionName(request);
        ThreadState threadState = null;
        if (messageExecutionContext.getConnectionStateProcessor() instanceof ProtobufConnectionAuthorizingStateProcessor) {
            threadState = ((ProtobufConnectionAuthorizingStateProcessor)messageExecutionContext.getConnectionStateProcessor()).prepareThreadForAuthorization();
        }
        try {
            function.getRequiredPermissions(regionName).forEach(arg_0 -> ((SecurityService)securityService).authorize(arg_0));
        }
        catch (NotAuthorizedException ex) {
            String message = "Authorization failed for function \"" + functionID + "\"";
            logger.warn(message, (Throwable)ex);
            Failure failure = Failure.of(BasicTypes.ErrorCode.AUTHORIZATION_FAILED, message);
            return failure;
        }
        finally {
            if (threadState != null) {
                ((ProtobufConnectionAuthorizingStateProcessor)messageExecutionContext.getConnectionStateProcessor()).restoreThreadState(threadState);
            }
        }
        Object executionTarget = this.getExecutionTarget(request, regionName, messageExecutionContext);
        if (executionTarget instanceof Failure) {
            return (Failure)executionTarget;
        }
        try {
            Set<?> parseFilter;
            Execution execution = this.getFunctionExecutionObject(executionTarget);
            Object arguments = this.getFunctionArguments(request, serializationService);
            if (arguments != null) {
                execution = execution.setArguments(arguments);
            }
            if ((parseFilter = this.parseFilter(serializationService, request)) != null) {
                execution = execution.withFilter(parseFilter);
            }
            ResultCollector resultCollector = execution.execute(functionID);
            if (function.hasResult()) {
                List results = (List)resultCollector.getResult();
                return this.buildResultMessage(serializationService, results);
            }
            return this.buildResultMessage(serializationService);
        }
        catch (FunctionException ex) {
            String message = "Function execution failed: " + ex.toString();
            logger.info(message, (Throwable)ex);
            return Failure.of(BasicTypes.ErrorCode.SERVER_ERROR, message);
        }
    }

    protected abstract Set<?> parseFilter(ProtobufSerializationService var1, Req var2) throws EncodingException, DecodingException;

    protected abstract String getFunctionID(Req var1);

    protected abstract String getRegionName(Req var1);

    protected abstract Object getExecutionTarget(Req var1, String var2, MessageExecutionContext var3) throws InvalidExecutionContextException;

    protected abstract Object getFunctionArguments(Req var1, ProtobufSerializationService var2) throws EncodingException, DecodingException;

    protected abstract Execution getFunctionExecutionObject(Object var1) throws InvalidExecutionContextException;

    protected abstract Result buildResultMessage(ProtobufSerializationService var1) throws EncodingException;

    protected abstract Result buildResultMessage(ProtobufSerializationService var1, List<Object> var2) throws EncodingException;
}

