/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.function.Function;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.security.ResourcePermission;

public class ProtobufOperationContext<OperationRequest, OperationResponse> {
    private final ProtobufOperationHandler<OperationRequest, OperationResponse> operationHandler;
    private final Function<ClientProtocol.Message, OperationRequest> fromRequest;
    private final Function<OperationResponse, ClientProtocol.Message.Builder> toResponse;
    private final Function<ClientProtocol.ErrorResponse, ClientProtocol.Message.Builder> toErrorResponse;
    private final PermissionFunction<OperationRequest> accessPermissionRequired;

    public ProtobufOperationContext(Function<ClientProtocol.Message, OperationRequest> fromRequest, ProtobufOperationHandler<OperationRequest, OperationResponse> operationHandler, Function<OperationResponse, ClientProtocol.Message.Builder> toResponse, ResourcePermission permissionRequired) {
        this.operationHandler = operationHandler;
        this.fromRequest = fromRequest;
        this.toResponse = toResponse;
        this.toErrorResponse = this::makeErrorBuilder;
        this.accessPermissionRequired = new StaticResourcePermissionProvider(permissionRequired);
    }

    public ProtobufOperationContext(Function<ClientProtocol.Message, OperationRequest> fromRequest, ProtobufOperationHandler<OperationRequest, OperationResponse> operationHandler, Function<OperationResponse, ClientProtocol.Message.Builder> toResponse, PermissionFunction<OperationRequest> permissionRequired) {
        this.operationHandler = operationHandler;
        this.fromRequest = fromRequest;
        this.toResponse = toResponse;
        this.toErrorResponse = this::makeErrorBuilder;
        this.accessPermissionRequired = permissionRequired;
    }

    protected ClientProtocol.Message.Builder makeErrorBuilder(ClientProtocol.ErrorResponse errorResponse) {
        return ClientProtocol.Message.newBuilder().setErrorResponse(errorResponse);
    }

    public ProtobufOperationHandler<OperationRequest, OperationResponse> getOperationHandler() {
        return this.operationHandler;
    }

    public Function<ClientProtocol.Message, OperationRequest> getFromRequest() {
        return this.fromRequest;
    }

    public Function<OperationResponse, ClientProtocol.Message.Builder> getToResponse() {
        return this.toResponse;
    }

    public Function<ClientProtocol.ErrorResponse, ClientProtocol.Message.Builder> getToErrorResponse() {
        return this.toErrorResponse;
    }

    public ResourcePermission getAccessPermissionRequired(OperationRequest request, ProtobufSerializationService serializer) throws DecodingException {
        return this.accessPermissionRequired.apply(request, serializer);
    }

    private class StaticResourcePermissionProvider
    implements PermissionFunction<OperationRequest> {
        private final ResourcePermission permission;

        StaticResourcePermissionProvider(ResourcePermission requiredPermission) {
            this.permission = requiredPermission;
        }

        @Override
        public ResourcePermission apply(OperationRequest request, ProtobufSerializationService serializer) {
            return this.permission;
        }
    }

    @FunctionalInterface
    public static interface PermissionFunction<OperationRequest> {
        public ResourcePermission apply(OperationRequest var1, ProtobufSerializationService var2) throws DecodingException;
    }
}

