/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.protocol.protobuf.security.SecureCache;
import org.apache.geode.internal.protocol.protobuf.security.SecureFunctionService;
import org.apache.geode.internal.protocol.protobuf.security.SecureFunctionServiceImpl;
import org.apache.geode.internal.protocol.protobuf.security.Security;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class SecureCacheImpl
implements SecureCache {
    protected final InternalCache cache;
    protected final Security security;
    private final SecureFunctionService functionService;

    public SecureCacheImpl(InternalCache cache, Security security) {
        this.cache = cache;
        this.security = security;
        this.functionService = new SecureFunctionServiceImpl(cache, security);
    }

    @Override
    public <K, V> void getAll(String regionName, Iterable<K> keys, BiConsumer<K, V> successConsumer, BiConsumer<K, Exception> failureConsumer) {
        Region region = this.getRegion(regionName);
        boolean authorized = this.tryAuthorizeAllKeys(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        keys.forEach(key -> {
            try {
                if (!authorized) {
                    this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
                }
                Object value = region.get(key);
                value = this.security.postProcess(regionName, key, value);
                successConsumer.accept(key, value);
            }
            catch (Exception e) {
                failureConsumer.accept(key, e);
            }
        });
    }

    @Override
    public <K, V> V get(String regionName, K key) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        Object value = region.get(key);
        return (V)this.security.postProcess(regionName, key, value);
    }

    @Override
    public <K, V> void put(String regionName, K key, V value) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        region.put(key, value);
    }

    @Override
    public <K, V> void putAll(String regionName, Map<K, V> entries, BiConsumer<K, Exception> failureConsumer) {
        boolean authorized = this.tryAuthorizeAllKeys(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        Region region = this.getRegion(regionName);
        entries.forEach((key, value) -> {
            try {
                if (!authorized) {
                    this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
                }
                region.put(key, value);
            }
            catch (Exception e) {
                failureConsumer.accept(key, e);
            }
        });
    }

    @Override
    public <K, V> V remove(String regionName, K key) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        Object oldValue = region.remove(key);
        return (V)this.security.postProcess(regionName, key, oldValue);
    }

    @Override
    public Collection<String> getRegionNames() {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, "*", "*");
        HashSet<String> regionNames = new HashSet<String>();
        this.cache.rootRegions().forEach(region -> {
            regionNames.add(region.getFullPath());
            region.subregions(true).stream().map(Region::getFullPath).forEach(regionNames::add);
        });
        return regionNames;
    }

    @Override
    public int getSize(String regionName) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, "*");
        return this.getRegion(regionName).size();
    }

    @Override
    public <K> Set<K> keySet(String regionName) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, "*");
        return this.getRegion(regionName).keySet();
    }

    @Override
    public SecureFunctionService getFunctionService() {
        return this.functionService;
    }

    @Override
    public void clear(String regionName) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, "*");
        Region region = this.getRegion(regionName);
        region.clear();
    }

    @Override
    public <K, V> V putIfAbsent(String regionName, K key, V value) {
        this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        Object oldValue = region.putIfAbsent(key, value);
        return (V)this.security.postProcess(regionName, key, oldValue);
    }

    @Override
    public Object query(String queryString, Object[] bindParameters) throws NameResolutionException, TypeMismatchException, QueryInvocationTargetException, FunctionDomainException {
        InternalQueryService queryService = (InternalQueryService)this.cache.getQueryService();
        Query query = queryService.newQuery(queryString);
        for (String regionName : ((DefaultQuery)query).getRegionsInQuery(bindParameters)) {
            this.security.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, "*");
        }
        Object result = query.execute(bindParameters);
        if (this.security.needsPostProcessing()) {
            return this.postProcessQueryResults(result);
        }
        return result;
    }

    private Object postProcessQueryResults(Object value) {
        if (!(value instanceof SelectResults)) {
            return this.security.postProcess(null, null, value);
        }
        SelectResults selectResults = (SelectResults)value;
        if (!selectResults.getCollectionType().getElementType().isStructType()) {
            List postProcessed = selectResults.stream().map(element -> this.security.postProcess(null, null, element)).collect(Collectors.toList());
            return new ResultsCollectionWrapper(selectResults.getCollectionType().getElementType(), postProcessed);
        }
        SelectResults structResults = selectResults;
        List postProcessed = structResults.stream().map(this::postProcessStruct).collect(Collectors.toList());
        return new ResultsCollectionWrapper(selectResults.getCollectionType().getElementType(), postProcessed);
    }

    private Struct postProcessStruct(Struct struct) {
        List newValues = Arrays.stream(struct.getFieldValues()).map(element -> this.security.postProcess(null, null, element)).collect(Collectors.toList());
        StructImpl newStruct = new StructImpl((StructTypeImpl)struct.getStructType(), newValues.toArray());
        return newStruct;
    }

    private <K, V> Region<K, V> getRegion(String regionName) {
        Region region = this.cache.getRegion(regionName);
        if (region == null) {
            throw new RegionDestroyedException("Region not found " + regionName, regionName);
        }
        return region;
    }

    private boolean tryAuthorizeAllKeys(ResourcePermission.Resource resource, ResourcePermission.Operation operation, String regionName) {
        try {
            this.security.authorize(resource, operation, regionName, "*");
            return true;
        }
        catch (NotAuthorizedException e) {
            return false;
        }
    }
}

