/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire;

import com.gemstone.gemfire.cache.execute.EmtpyRegionFunctionException;
import java.io.DataInput;
import java.io.DataOutput;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;

public class OldClientSupportProvider
implements OldClientSupportService {
    static final String GEODE = "org.apache.geode";
    static final String GEMFIRE = "com.gemstone.gemfire";

    public static OldClientSupportService getService(Cache cache) {
        return (OldClientSupportService)((InternalCache)cache).getService(OldClientSupportService.class);
    }

    public void init(Cache cache) {
        InternalDataSerializer.setOldClientSupportService((OldClientSupportService)this);
    }

    public Class<? extends CacheService> getInterface() {
        return OldClientSupportService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    public String processIncomingClassName(String name) {
        if (name.startsWith(GEMFIRE)) {
            return GEODE + name.substring(GEMFIRE.length());
        }
        return name;
    }

    public String processIncomingClassName(String name, DataInput in) {
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(oldPackage)) {
            return newPackage + name.substring(oldPackage.length());
        }
        if (name.startsWith(GEMFIRE)) {
            return GEODE + name.substring(GEMFIRE.length());
        }
        return name;
    }

    public String processOutgoingClassName(String name, DataOutput out) {
        VersionedDataOutputStream vout;
        Version version;
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(newPackage)) {
            return oldPackage + name.substring(newPackage.length());
        }
        if (out instanceof VersionedDataOutputStream && (version = (vout = (VersionedDataOutputStream)out).getVersion()) != null && version.compareTo(Version.GFE_90) < 0 && name.startsWith(GEODE)) {
            name = GEMFIRE + name.substring(GEODE.length());
        }
        return name;
    }

    public Throwable getThrowable(Throwable theThrowable, Version clientVersion) {
        if (theThrowable == null) {
            return theThrowable;
        }
        if (clientVersion.compareTo(Version.GFE_90) >= 0) {
            return theThrowable;
        }
        String className = theThrowable.getClass().getName();
        if (className.equals("org.apache.geode.cache.execute.EmptyRegionFunctionException")) {
            return new EmtpyRegionFunctionException(theThrowable.getMessage(), theThrowable.getCause());
        }
        return theThrowable;
    }
}

