/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.IOException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.geode.modules.session.catalina.DeltaSession7;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;

public class Tomcat7DeltaSessionManager
extends DeltaSessionManager {
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    public void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((Object)((Object)this) + ": Starting"));
        }
        if (this.started.get()) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.registerJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.registerCommitSessionValve();
        }
        this.initializeSessionCache();
        try {
            this.load();
        }
        catch (ClassNotFoundException e) {
            throw new LifecycleException("Exception starting manager", (Throwable)e);
        }
        catch (IOException e) {
            throw new LifecycleException("Exception starting manager", (Throwable)e);
        }
        this.scheduleTimerTasks();
        this.started.set(true);
        this.setState(LifecycleState.STARTING);
    }

    public void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((Object)((Object)this) + ": Stopping"));
        }
        try {
            this.unload();
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Unable to unload sessions", (Throwable)e);
        }
        this.started.set(false);
        this.lifecycle.fireLifecycleEvent("stop", null);
        super.destroyInternal();
        this.getSessionsToTouch().clear();
        this.cancelTimer();
        this.unregisterJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.unregisterCommitSessionValve();
        }
        this.setState(LifecycleState.STOPPING);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected StandardSession getNewSession() {
        return new DeltaSession7((Manager)this);
    }
}

