/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.installer.args;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.geode.modules.session.installer.args.Argument;
import org.apache.geode.modules.session.installer.args.ArgumentHandler;
import org.apache.geode.modules.session.installer.args.UsageException;

public class URLArgumentHandler
implements ArgumentHandler {
    private static final Logger LOG = Logger.getLogger(URLArgumentHandler.class.getName());

    @Override
    public void handleArgument(Argument arg, String form, String[] parameters) throws UsageException {
        File file = new File(parameters[0]);
        URL result = null;
        if (file.exists()) {
            try {
                result = file.toURI().toURL();
            }
            catch (MalformedURLException mux) {
                LOG.log(Level.FINEST, "Caught Exception", mux);
            }
        }
        if (result == null) {
            try {
                result = new URL(parameters[0]);
            }
            catch (MalformedURLException mux) {
                LOG.log(Level.FINEST, "Caught Exception", mux);
            }
        }
        if (result == null) {
            throw new UsageException("Argument parameter value is not a valid file path or URL: " + arg);
        }
        parameters[0] = result.toString();
    }
}

