/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.installer.args;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.geode.modules.session.installer.args.Argument;
import org.apache.geode.modules.session.installer.args.ArgumentHandler;
import org.apache.geode.modules.session.installer.args.ArgumentValues;
import org.apache.geode.modules.session.installer.args.UnknownArgumentHandler;
import org.apache.geode.modules.session.installer.args.UsageException;

public class ArgumentProcessor {
    private static final Logger LOG = Logger.getLogger(ArgumentProcessor.class.getName());
    private static final int LINE_LENGTH = 60;
    private final List<Argument> args = new ArrayList<Argument>();
    private UnknownArgumentHandler handler;
    private String programName;

    public ArgumentProcessor(String progName) {
        this.programName = progName;
    }

    public void addArgument(Argument arg) {
        this.args.add(arg);
    }

    public void setUnknownArgumentHandler(UnknownArgumentHandler aHandler) {
        this.handler = aHandler;
    }

    public ArgumentValues process(String[] programArgs) throws UsageException {
        ArgumentValues result = new ArgumentValues();
        List<Match> matches = this.checkMatches(programArgs, result);
        ArrayList<Argument> unmatched = new ArrayList<Argument>();
        unmatched.addAll(this.args);
        for (Match match : matches) {
            unmatched.remove(match.getArgument());
        }
        for (Argument arg : unmatched) {
            if (!arg.isRequired() || arg.isDefinedInEnv()) continue;
            UsageException usageException = new UsageException("Required argument not provided: " + arg);
            usageException.setUsage(this.getUsage());
            throw usageException;
        }
        for (Match match : matches) {
            Argument arg = match.getArgument();
            ArgumentHandler argHandler = arg.getArgumentHandler();
            if (argHandler != null) {
                argHandler.handleArgument(arg, match.getForm(), match.getParams());
            }
            result.addResult(arg, match.getParams());
        }
        return result;
    }

    public String getUsage() {
        StringBuilder builder = new StringBuilder();
        String blank20 = "                    ";
        builder.append("\nUSAGE: ");
        if (this.programName == null) {
            builder.append("<program>");
        } else {
            builder.append(this.programName);
        }
        if (this.args.isEmpty()) {
            builder.append("\nNo arguments supported.\n");
        } else {
            builder.append(" <args>\nWHERE <args>:\n\n");
            for (Argument arg : this.args) {
                for (String form : arg.getForms()) {
                    builder.append("    ");
                    builder.append(form);
                    for (int i = 0; i < arg.getParameterCount(); ++i) {
                        builder.append(" <");
                        builder.append(arg.getParameterName(i));
                        builder.append(">");
                    }
                    builder.append("\n");
                }
                List<String> descriptionLines = this.breakupString(arg.getDescription(), 60);
                if (descriptionLines.isEmpty()) {
                    builder.append("                    ");
                    builder.append("No argument description provided.");
                    builder.append("\n\n");
                    continue;
                }
                for (String line : descriptionLines) {
                    builder.append("                    ");
                    builder.append(line.trim());
                    builder.append("\n");
                }
                builder.append("\n");
            }
        }
        builder.append("\n");
        return builder.toString();
    }

    private List<Match> checkMatches(String[] programArgs, ArgumentValues values) throws UsageException {
        String[] params;
        ArrayList<Match> result = new ArrayList<Match>();
        for (int idx = 0; idx < programArgs.length; idx += params.length + 1) {
            if ("--".equals(programArgs[idx])) {
                if (++idx >= programArgs.length) break;
                String[] postArgs = new String[programArgs.length - idx];
                System.arraycopy(programArgs, idx, postArgs, 0, postArgs.length);
                values.setPostArgs(postArgs);
                break;
            }
            int idx2 = idx;
            while (idx2 + 1 < programArgs.length && programArgs[idx2 + 1].charAt(0) != '-') {
                ++idx2;
            }
            params = new String[idx2 - idx];
            System.arraycopy(programArgs, idx + 1, params, 0, params.length);
            LOG.fine("Arg: " + programArgs[idx]);
            LOG.fine("Params: " + params.length);
            Match match = null;
            for (Argument arg : this.args) {
                match = this.checkMatch(programArgs[idx], arg, params);
                if (match == null) continue;
                result.add(match);
                LOG.fine("Match found: ");
                LOG.fine("     ID: " + arg);
                LOG.fine("   Form: " + match.getForm());
                break;
            }
            if (match != null) continue;
            if (this.handler == null) {
                UsageException usageException = new UsageException("Unknown argument: " + programArgs[idx] + " with " + params.length + " parameters.");
                usageException.setUsage(this.getUsage());
                throw usageException;
            }
            this.handler.handleUnknownArgument(programArgs[idx], params);
        }
        return result;
    }

    private Match checkMatch(String argName, Argument arg, String[] params) {
        for (String form : arg.getForms()) {
            if (!form.equals(argName) || arg.getParameterCount() != params.length) continue;
            return new Match(arg, form, params);
        }
        return null;
    }

    private List<String> breakupString(String str, int maxLength) {
        ArrayList<String> result = new ArrayList<String>();
        int startIdx = -1;
        if (str == null) {
            return result;
        }
        while (true) {
            int lastIdx;
            int idx = startIdx;
            do {
                lastIdx = idx;
                idx = str.indexOf(32, lastIdx + 1);
                LOG.fine("startIdx=" + startIdx + "  lastIdx=" + lastIdx + "  idx=" + idx);
                if (idx >= 0) continue;
                result.add(str.substring(startIdx + 1));
                return result;
            } while (idx - startIdx <= maxLength);
            result.add(str.substring(startIdx + 1, lastIdx));
            startIdx = lastIdx;
        }
    }

    private static class Match {
        private final Argument arg;
        private final String form;
        private final String[] params;

        public Match(Argument theArgument, String theForm, String[] theParams) {
            this.arg = theArgument;
            this.form = theForm;
            this.params = theParams;
        }

        public Argument getArgument() {
            return this.arg;
        }

        public String getForm() {
            return this.form;
        }

        public String[] getParams() {
            return this.params;
        }
    }
}

