/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.installer;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.geode.modules.session.installer.args.Argument;
import org.apache.geode.modules.session.installer.args.ArgumentProcessor;
import org.apache.geode.modules.session.installer.args.ArgumentValues;
import org.apache.geode.modules.session.installer.args.UnknownArgumentHandler;
import org.apache.geode.modules.session.installer.args.UsageException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Installer {
    private static final String GEMFIRE_FILTER_CLASS = "org.apache.geode.modules.session.filter.SessionCachingFilter";
    private static final String GEMFIRE_LISTENER_CLASS = "org.apache.geode.modules.session.filter.SessionListener";
    private ArgumentValues argValues;
    private static final Argument ARG_HELP = new Argument("-h", false, new String[0]).setDescription("Displays this help message.");
    private static Argument ARG_GEMFIRE_PARAMETERS = new Argument("-p", false, "param=value").setDescription("Specific parameter for inclusion into the session filter definition as a regular init-param. Can be given multiple times.");
    private static Argument ARG_CACHE_TYPE = new Argument("-t", false, "cache-type").setDescription("Type of cache. Must be one of 'peer-to-peer' or 'client-server'. Default is peer-to-peer.").setDefaults("peer-to-peer");
    private static Argument ARG_WEB_XML_FILE = new Argument("-w", true, "web.xml file").setDescription("The web.xml file to be modified.");

    public static void main(String[] args) throws Exception {
        new Installer(args).process();
    }

    public static void log(String message) {
        System.err.println(message);
    }

    public Installer(String[] args) throws Exception {
        ArgumentProcessor processor = new ArgumentProcessor("Installer");
        this.argValues = null;
        try {
            processor.addArgument(ARG_HELP);
            processor.addArgument(ARG_GEMFIRE_PARAMETERS);
            processor.addArgument(ARG_CACHE_TYPE);
            processor.addArgument(ARG_WEB_XML_FILE);
            processor.setUnknownArgumentHandler(new UnknownArgumentHandler(){

                @Override
                public void handleUnknownArgument(String form, String[] params) {
                    Installer.log("Unknown argument being ignored: " + form + " (" + params.length + " params)");
                    Installer.log("Use '-h' argument to display usage");
                }
            });
            this.argValues = processor.process(args);
            if (this.argValues.isDefined(ARG_HELP)) {
                UsageException usageException = new UsageException("Usage requested by user");
                usageException.setUsage(processor.getUsage());
                throw usageException;
            }
        }
        catch (UsageException ux) {
            StringBuilder error = new StringBuilder();
            error.append("\nERROR: ");
            error.append(ux.getMessage());
            error.append("\n");
            if (ux.getUsage() != null) {
                error.append(ux.getUsage());
            }
            Installer.log(error.toString());
            System.exit(2);
        }
    }

    public void process() throws Exception {
        String argInputFile = this.argValues.getFirstResult(ARG_WEB_XML_FILE);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileInputStream input = new FileInputStream(argInputFile);
        this.processWebXml(input, output);
        ((InputStream)input).close();
        System.out.println(output.toString());
    }

    public void processWebXml(InputStream webXml, OutputStream out) throws Exception {
        Document doc = this.createWebXmlDoc(webXml);
        this.mangleWebXml(doc);
        this.streamXML(doc, out);
    }

    private Document createWebXmlDoc(InputStream webXml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(webXml);
        return doc;
    }

    private Document mangleWebXml(Document doc) {
        Node first;
        Element docElement = doc.getDocumentElement();
        NodeList nodelist = docElement.getChildNodes();
        Node firstFilter = null;
        Node displayElement = null;
        Node afterDisplayElement = null;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            String name = node.getNodeName();
            if ("display-name".equals(name)) {
                displayElement = node;
                continue;
            }
            if ("filter".equals(name) && firstFilter == null) {
                firstFilter = node;
            }
            if (displayElement == null || afterDisplayElement != null) continue;
            afterDisplayElement = node;
        }
        Element filter = doc.createElement("filter");
        this.append(doc, filter, "filter-name", "gemfire-session-filter");
        this.append(doc, filter, "filter-class", GEMFIRE_FILTER_CLASS);
        Node initParam = this.append(doc, filter, "init-param", null);
        this.append(doc, initParam, "param-name", "cache-type");
        this.append(doc, initParam, "param-value", this.argValues.getFirstResult(ARG_CACHE_TYPE));
        if (this.argValues.isDefined(ARG_GEMFIRE_PARAMETERS)) {
            for (String[] val : this.argValues.getAllResults(ARG_GEMFIRE_PARAMETERS)) {
                String gfParam = val[0];
                int idx = gfParam.indexOf("=");
                initParam = this.append(doc, filter, "init-param", null);
                this.append(doc, initParam, "param-name", gfParam.substring(0, idx));
                this.append(doc, initParam, "param-value", gfParam.substring(idx + 1));
            }
        }
        if ((first = firstFilter) == null && afterDisplayElement != null) {
            first = afterDisplayElement;
        }
        if (first == null) {
            first = docElement.getFirstChild();
        }
        docElement.insertBefore(filter, first);
        Element filterMapping = doc.createElement("filter-mapping");
        this.append(doc, filterMapping, "filter-name", "gemfire-session-filter");
        this.append(doc, filterMapping, "url-pattern", "/*");
        Element contextListener = doc.createElement("listener");
        this.append(doc, contextListener, "listener-class", GEMFIRE_LISTENER_CLASS);
        docElement.insertBefore(filterMapping, this.after(docElement, "filter"));
        docElement.insertBefore(contextListener, this.after(docElement, "filter-mapping"));
        return doc;
    }

    private Node after(Node parent, String nodeName) {
        NodeList nodelist = parent.getChildNodes();
        int index = -1;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            String name = node.getNodeName();
            if (!nodeName.equals(name)) continue;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        if (nodelist.getLength() > index + 1) {
            return nodelist.item(index + 1);
        }
        return null;
    }

    private Node append(Document doc, Node parent, String element, String value) {
        Element child = doc.createElement(element);
        if (value != null) {
            child.setTextContent(value);
        }
        parent.appendChild(child);
        return child;
    }

    private void streamXML(Document doc, OutputStream out) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (doc.getDoctype() != null) {
                String systemId = doc.getDoctype().getSystemId();
                String publicId = doc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", publicId);
                transformer.setOutputProperty("doctype-system", systemId);
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

