/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.geode.modules.session.internal.filter.GemfireHttpSession;
import org.apache.geode.modules.session.internal.filter.GemfireSessionManager;
import org.apache.geode.modules.session.internal.filter.SessionManager;
import org.apache.geode.modules.session.internal.filter.util.ThreadLocalSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCachingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger((String)SessionCachingFilter.class.getName());
    private FilterConfig filterConfig = null;
    private static SessionManager manager = null;
    private static AtomicInteger started = new AtomicInteger(Integer.getInteger("gemfire.override.session.manager.count", 1));
    private static int percentInactiveTimeTriggerRebuild = Integer.getInteger("gemfire.session.inactive.trigger.rebuild", 80);
    private static CountDownLatch startingLatch = new CountDownLatch(1);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        if (this.alreadyWrapped((ServletRequest)httpReq)) {
            LOG.debug("Handling already-wrapped request");
            chain.doFilter(request, response);
            return;
        }
        ResponseWrapper wrappedResponse = new ResponseWrapper(httpResp);
        RequestWrapper wrappedRequest = new RequestWrapper(manager, httpReq, wrappedResponse);
        Throwable problem = null;
        try {
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        catch (Throwable t) {
            problem = t;
            LOG.error("Exception processing filter chain", t);
        }
        GemfireHttpSession session = (GemfireHttpSession)wrappedRequest.getSession(false);
        if (problem != null) {
            if (problem instanceof ServletException) {
                throw (ServletException)problem;
            }
            if (problem instanceof IOException) {
                throw (IOException)problem;
            }
            this.sendProcessingError(problem, response);
        }
        if (session != null) {
            session.commit();
        }
    }

    private boolean alreadyWrapped(ServletRequest request) {
        if (request instanceof RequestWrapper) {
            return true;
        }
        if (!(request instanceof ServletRequestWrapper)) {
            return false;
        }
        ServletRequest nestedRequest = ((ServletRequestWrapper)request).getRequest();
        if (nestedRequest == request) {
            return false;
        }
        return this.alreadyWrapped(nestedRequest);
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        if (manager != null) {
            manager.stop();
        }
    }

    public void init(FilterConfig config) {
        LOG.info("Starting Session Filter initialization");
        this.filterConfig = config;
        if (started.getAndDecrement() > 0) {
            String managerClassStr = config.getInitParameter("session-manager-class");
            if (managerClassStr == null) {
                managerClassStr = GemfireSessionManager.class.getName();
            }
            try {
                manager = (SessionManager)Class.forName(managerClassStr).newInstance();
                manager.start((Object)config, this.getClass().getClassLoader());
            }
            catch (Exception ex) {
                LOG.error("Exception creating Session Manager", (Throwable)ex);
            }
            startingLatch.countDown();
        } else {
            try {
                startingLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.debug("SessionManager and listener initialization skipped - already done.");
        }
        LOG.info("Session Filter initialization complete");
        LOG.debug("Filter class loader {}", (Object)this.getClass().getClassLoader());
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "SessionCachingFilter()";
        }
        StringBuilder sb = new StringBuilder("SessionCachingFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    private void sendProcessingError(Throwable t, ServletResponse response) {
        String stackTrace = SessionCachingFilter.getStackTrace(t);
        if (stackTrace != null && !stackTrace.equals("")) {
            try {
                response.setContentType("text/html");
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                PrintWriter pw = new PrintWriter(ps);
                pw.print("<html>\n<head>\n<title>Error</title>\n</head>\n<body>\n");
                pw.print("<h1>The resource did not process correctly</h1>\n<pre>\n");
                pw.print(stackTrace);
                pw.print("</pre></body>\n</html>");
                pw.close();
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ps) {}
        } else {
            try {
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                t.printStackTrace(ps);
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    public static SessionManager getSessionManager() {
        return manager;
    }

    public static HttpSession getWrappingSession(HttpSession nativeSession) {
        GemfireHttpSession gemfireSession = (GemfireHttpSession)ThreadLocalSession.get();
        if (gemfireSession != null) {
            gemfireSession.setNativeSession(nativeSession);
            return gemfireSession;
        }
        return SessionCachingFilter.getSessionManager().getWrappingSession(nativeSession.getId());
    }

    class ResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletResponse originalResponse;

        public ResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
            this.originalResponse = response;
        }

        public HttpServletResponse getOriginalResponse() {
            return this.originalResponse;
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            super.setIntHeader(name, value);
        }
    }

    public static class RequestWrapper
    extends HttpServletRequestWrapper {
        private static final String URL_SESSION_IDENTIFIER = ";jsessionid=";
        private ResponseWrapper response;
        private boolean sessionFromCookie = false;
        private boolean sessionFromURL = false;
        private String requestedSessionId = null;
        private GemfireHttpSession session = null;
        private SessionManager manager;
        private HttpServletRequest outerRequest = null;
        private HttpServletRequest originalRequest;

        public RequestWrapper(SessionManager manager, HttpServletRequest request, ResponseWrapper response) {
            super(request);
            this.response = response;
            this.manager = manager;
            this.originalRequest = request;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase(manager.getSessionCookieName()) || !cookie.getValue().endsWith("-GF")) continue;
                    this.requestedSessionId = cookie.getValue();
                    this.sessionFromCookie = true;
                    LOG.debug("Cookie contains sessionId: {}", (Object)this.requestedSessionId);
                }
            }
            if (this.requestedSessionId == null) {
                this.requestedSessionId = this.extractSessionId();
                LOG.debug("Extracted sessionId from URL {}", (Object)this.requestedSessionId);
                if (this.requestedSessionId != null) {
                    this.sessionFromURL = true;
                }
            }
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpSession getSession(boolean create) {
            HttpSession nativeSession;
            super.getSession(false);
            if (this.session != null && this.session.isValid()) {
                this.session.setIsNew(false);
                this.session.updateAccessTime();
                return this.session;
            }
            if (this.requestedSessionId != null) {
                this.session = (GemfireHttpSession)this.manager.getSession(this.requestedSessionId);
                if (this.session != null) {
                    this.session.setIsNew(false);
                    if (this.session.getNativeSession() == null) {
                        try {
                            ThreadLocalSession.set((HttpSession)this.session);
                            nativeSession = super.getSession();
                            this.session.failoverSession(nativeSession);
                            this.session.putInRegion();
                        }
                        finally {
                            ThreadLocalSession.remove();
                        }
                    }
                }
            }
            if (this.session == null || !this.session.isValid()) {
                if (create) {
                    try {
                        this.session = (GemfireHttpSession)this.manager.wrapSession(null);
                        ThreadLocalSession.set((HttpSession)this.session);
                        nativeSession = super.getSession();
                        if (this.session.getNativeSession() == null) {
                            this.session.setNativeSession(nativeSession);
                        } else assert (this.session.getNativeSession() == nativeSession);
                        this.session.setIsNew(true);
                        this.manager.putSession((HttpSession)this.session);
                    }
                    finally {
                        ThreadLocalSession.remove();
                    }
                } else {
                    return null;
                }
            }
            if (this.session != null) {
                this.addSessionCookie((HttpServletResponse)this.response);
                this.session.updateAccessTime();
            }
            return this.session;
        }

        private void addSessionCookie(HttpServletResponse response) {
            if (response.isCommitted()) {
                return;
            }
            Cookie[] cookies = this.getCookies();
            Cookie cookie = new Cookie(this.manager.getSessionCookieName(), this.session.getId());
            cookie.setPath("".equals(this.getContextPath()) ? "/" : this.getContextPath());
            response.addCookie(cookie);
        }

        private String getCookieString(Cookie c) {
            StringBuilder cookie = new StringBuilder();
            cookie.append(c.getName()).append("=").append(c.getValue());
            if (c.getPath() != null) {
                cookie.append("; ").append("Path=").append(c.getPath());
            }
            if (c.getDomain() != null) {
                cookie.append("; ").append("Domain=").append(c.getDomain());
            }
            if (c.getSecure()) {
                cookie.append("; ").append("Secure");
            }
            cookie.append("; HttpOnly");
            return cookie.toString();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.sessionFromCookie;
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.sessionFromURL;
        }

        public String getRequestedSessionId() {
            if (this.requestedSessionId != null) {
                return this.requestedSessionId;
            }
            return super.getRequestedSessionId();
        }

        public Principal getUserPrincipal() {
            if (this.outerRequest != null) {
                return this.outerRequest.getUserPrincipal();
            }
            return super.getUserPrincipal();
        }

        public String getRemoteUser() {
            if (this.outerRequest != null) {
                return this.outerRequest.getRemoteUser();
            }
            return super.getRemoteUser();
        }

        public boolean isUserInRole(String role) {
            if (this.outerRequest != null) {
                return this.outerRequest.isUserInRole(role);
            }
            return super.isUserInRole(role);
        }

        void setOuterWrapper(HttpServletRequest outer) {
            this.outerRequest = outer;
        }

        private String extractSessionId() {
            int prefix = this.getRequestURL().indexOf(URL_SESSION_IDENTIFIER);
            if (prefix != -1) {
                int start = prefix + URL_SESSION_IDENTIFIER.length();
                int suffix = this.getRequestURL().indexOf("?", start);
                if (suffix < 0) {
                    suffix = this.getRequestURL().indexOf("#", start);
                }
                if (suffix <= prefix) {
                    return this.getRequestURL().substring(start);
                }
                return this.getRequestURL().substring(start, suffix);
            }
            return null;
        }
    }
}

