/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.installer.args;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.modules.session.installer.args.Argument;

public class ArgumentValues {
    private String[] postArgs = new String[0];
    private final Map<Argument, List<String[]>> values = new LinkedHashMap<Argument, List<String[]>>();

    ArgumentValues() {
    }

    void setPostArgs(String[] newPostArgs) {
        this.postArgs = newPostArgs;
    }

    public String[] getPostArgs() {
        return this.postArgs;
    }

    public void addResult(Argument arg, String[] paramValues) {
        List<String[]> list = this.values.get(arg);
        if (list == null) {
            list = new ArrayList<String[]>();
            list.add(paramValues);
            this.values.put(arg, list);
        } else {
            list.add(paramValues);
        }
    }

    public Set<Argument> getDefinedArguments() {
        return this.values.keySet();
    }

    public int getDefinedCount(Argument ... ofThese) {
        if (ofThese.length == 0) {
            return this.values.keySet().size();
        }
        int count = 0;
        for (Argument arg : this.values.keySet()) {
            boolean found = false;
            for (int i = 0; !found && i < ofThese.length; ++i) {
                if (!ofThese[i].equals(arg)) continue;
                ++count;
                found = true;
            }
        }
        return count;
    }

    public boolean isDefined(Argument arg) {
        List<String[]> result = this.values.get(arg);
        return result != null;
    }

    public List<String[]> getAllResults(Argument arg) {
        List<String[]> result = this.values.get(arg);
        if (result == null) {
            String[] envVars = arg.getEnvVars();
            String[] defaults = arg.getDefaults();
            String[] vals = new String[arg.getParameterCount()];
            boolean found = defaults != null;
            for (int i = 0; i < arg.getParameterCount(); ++i) {
                String val;
                if (defaults != null) {
                    vals[i] = defaults[i];
                }
                if (envVars == null || (val = System.getenv(envVars[i])) == null) continue;
                found = true;
                vals[i] = val;
            }
            if (found) {
                result = new ArrayList<String[]>();
                result.add(vals);
            }
        }
        return result;
    }

    public String[] getResult(Argument arg) {
        List<String[]> all = this.getAllResults(arg);
        if (all == null) {
            return null;
        }
        return all.get(0);
    }

    public String getFirstResult(Argument arg) {
        String[] all = this.getResult(arg);
        if (all == null) {
            return null;
        }
        return all[0];
    }

    public int getFirstResultAsInt(Argument arg, int undefinedValue) {
        String value = this.getFirstResult(arg);
        if (value == null) {
            return undefinedValue;
        }
        return Integer.parseInt(value);
    }
}

