/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.installer.args;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.modules.session.installer.args.ArgumentHandler;

public class Argument {
    private final String[] paramNames;
    private String[] defaults;
    private String[] envVars;
    private final boolean required;
    private ArgumentHandler handler;
    private final List<String> forms = new ArrayList<String>();
    private String description;

    public Argument(String primaryForm, boolean argRequired, String ... parameterNames) {
        this.forms.add(primaryForm);
        this.paramNames = parameterNames;
        this.required = argRequired;
    }

    public int getParameterCount() {
        return this.paramNames.length;
    }

    public String getParameterName(int idx) {
        return this.paramNames[idx];
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDefinedInEnv() {
        if (this.envVars == null || this.paramNames.length == 0) {
            return false;
        }
        for (String var : this.envVars) {
            if (System.getenv(var) != null) continue;
            return false;
        }
        return true;
    }

    public Argument setArgumentHandler(ArgumentHandler aHandler) {
        this.handler = aHandler;
        return this;
    }

    public ArgumentHandler getArgumentHandler() {
        return this.handler;
    }

    public Argument addForm(String aliasName) {
        this.forms.add(aliasName);
        return this;
    }

    public String getPrimaryForm() {
        if (this.forms.isEmpty()) {
            return null;
        }
        return this.forms.get(0);
    }

    public List<String> getForms() {
        return this.forms;
    }

    public Argument setDescription(String str) {
        this.description = str;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Argument setDefaults(String ... newDefaults) {
        if (newDefaults.length != this.paramNames.length) {
            throw new IllegalArgumentException("Defaults array length provided is not the correct size");
        }
        this.defaults = newDefaults;
        return this;
    }

    public String[] getDefaults() {
        return this.defaults;
    }

    public Argument setEnvVars(String ... newEnvVars) {
        if (newEnvVars.length != this.paramNames.length) {
            throw new IllegalArgumentException("Environment variables array length provided is not the correct size");
        }
        this.envVars = newEnvVars;
        return this;
    }

    public String[] getEnvVars() {
        return this.envVars;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Argument '");
        builder.append(this.forms.get(0));
        builder.append("'");
        if (this.paramNames.length > 0) {
            for (int i = 0; i < this.paramNames.length; ++i) {
                builder.append(" <");
                builder.append(this.paramNames[i]);
                builder.append(">");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

