/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.filter;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.modules.session.filter.SessionCachingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionListener
implements HttpSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)SessionListener.class.getName());

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        String nativeId = event.getSession().getId();
        try {
            String sessionId = SessionCachingFilter.getSessionManager().destroyNativeSession(nativeId);
            LOG.debug("Received sessionDestroyed event for native session {} (wrapped by {})", (Object)nativeId, (Object)sessionId);
        }
        catch (DistributedSystemDisconnectedException dex) {
            LOG.debug("Cache disconnected - unable to destroy native session {0}", (Object)nativeId);
        }
    }
}

