/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger LOG = Logger.getLogger(NamedThreadFactory.class.getName());
    private final String id;
    private final AtomicLong serial = new AtomicLong();

    public NamedThreadFactory(String poolID) {
        this.id = poolID;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thr = new Thread(r);
        thr.setDaemon(true);
        thr.setName(this.id + " - " + this.serial.incrementAndGet());
        thr.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.log(Level.WARNING, "Uncaught Exception in thread: " + t.getName(), e);
            }
        });
        return thr;
    }
}

