/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.modules.session.internal.filter.GemfireHttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaEvent
implements DataSerializable {
    private static final Logger LOG = LoggerFactory.getLogger((String)DeltaEvent.class.getName());
    private boolean update;
    private String name;
    private Object value = null;
    private GemfireHttpSession session = null;

    public DeltaEvent() {
    }

    public DeltaEvent(GemfireHttpSession session, String attribute) {
        this.session = session;
        this.name = attribute;
        this.update = true;
    }

    public DeltaEvent(boolean update, String attribute, Object value) {
        this.update = update;
        this.name = attribute;
        this.value = value;
        this.blobifyValue();
    }

    private void blobifyValue() {
        if (this.value instanceof byte[]) {
            LOG.warn("Session attribute is already a byte[] - problems may occur transmitting this delta.");
        }
        try {
            this.value = BlobHelper.serializeToBlob((Object)this.value);
        }
        catch (IOException iox) {
            LOG.error("Attribute '" + this.name + "' value: " + this.value + " cannot be serialized due to the following exception", (Throwable)iox);
        }
    }

    public boolean isUpdate() {
        return this.update;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void toData(DataOutput out) throws IOException {
        if (this.session != null) {
            this.value = this.session.getNativeSession().getAttribute(this.name);
            this.blobifyValue();
        }
        out.writeBoolean(this.update);
        DataSerializer.writeString((String)this.name, (DataOutput)out);
        DataSerializer.writeObject((Object)this.value, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.update = in.readBoolean();
        this.name = DataSerializer.readString((DataInput)in);
        this.value = DataSerializer.readObject((DataInput)in);
    }
}

