/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.modules.session.internal.filter.GemfireHttpSession;
import org.apache.geode.modules.session.internal.filter.attributes.DeltaEvent;
import org.apache.geode.modules.session.internal.filter.attributes.SessionAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionAttributes
implements SessionAttributes {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractSessionAttributes.class.getName());
    protected Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    protected transient GemfireHttpSession session;
    protected long lastAccessedTime;
    protected int maxInactiveInterval = 1800;
    protected String jvmOwnerId;

    @Override
    public void setSession(GemfireHttpSession session) {
        this.session = session;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value instanceof byte[]) {
            try {
                value = BlobHelper.deserializeBlob((byte[])((byte[])value));
                this.attributes.put(name, value);
            }
            catch (Exception iox) {
                LOG.error("Attribute '" + name + " contains a byte[] that cannot be deserialized due " + "to the following exception", (Throwable)iox);
            }
        }
        return value;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxIntactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setLastAccessedTime(long time) {
        this.lastAccessedTime = time;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public void flush() {
        this.session.putInRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.maxInactiveInterval);
        out.writeLong(this.lastAccessedTime);
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            out.writeInt(this.attributes.size());
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                DeltaEvent delta = new DeltaEvent(true, entry.getKey(), entry.getValue());
                DataSerializer.writeObject((Object)delta, (DataOutput)out);
            }
        }
        out.writeUTF(this.jvmOwnerId);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.maxInactiveInterval = in.readInt();
        this.lastAccessedTime = in.readLong();
        int size = in.readInt();
        while (size-- > 0) {
            DeltaEvent event = (DeltaEvent)DataSerializer.readObject((DataInput)in);
            this.attributes.put(event.getName(), event.getValue());
        }
        this.jvmOwnerId = in.readUTF();
    }

    @Override
    public void setJvmOwnerId(String jvmId) {
        this.jvmOwnerId = jvmId;
    }

    @Override
    public String getJvmOwnerId() {
        return this.jvmOwnerId;
    }
}

