/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.modules.session.internal.filter.attributes.AbstractSessionAttributes;
import org.apache.geode.modules.session.internal.filter.attributes.DeltaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeltaSessionAttributes
extends AbstractSessionAttributes
implements Delta {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractDeltaSessionAttributes.class.getName());
    protected transient Map<String, DeltaEvent> deltas = Collections.synchronizedMap(new HashMap());

    public boolean hasDelta() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toDelta(DataOutput out) throws IOException {
        out.writeInt(this.maxInactiveInterval);
        out.writeLong(this.lastAccessedTime);
        Map<String, DeltaEvent> map = this.deltas;
        synchronized (map) {
            DataSerializer.writeInteger((Integer)this.deltas.size(), (DataOutput)out);
            for (Map.Entry<String, DeltaEvent> e : this.deltas.entrySet()) {
                DataSerializer.writeString((String)e.getKey(), (DataOutput)out);
                DataSerializer.writeObject((Object)e.getValue(), (DataOutput)out);
            }
            this.deltas.clear();
        }
        out.writeUTF(this.jvmOwnerId);
    }

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        this.maxInactiveInterval = in.readInt();
        this.lastAccessedTime = in.readLong();
        HashMap<String, DeltaEvent> localDeltas = new HashMap<String, DeltaEvent>();
        try {
            int size = DataSerializer.readInteger((DataInput)in);
            for (int i = 0; i < size; ++i) {
                String key = DataSerializer.readString((DataInput)in);
                DeltaEvent evt = (DeltaEvent)DataSerializer.readObject((DataInput)in);
                localDeltas.put(key, evt);
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.error("Unable to de-serialize delta events", (Throwable)ex);
            return;
        }
        LOG.debug("Processing {} delta events for {}", (Object)localDeltas.size(), (Object)this.session);
        for (DeltaEvent e : localDeltas.values()) {
            if (e.isUpdate()) {
                this.attributes.put(e.getName(), e.getValue());
                if (this.session.getNativeSession() == null) continue;
                this.session.getNativeSession().setAttribute(e.getName(), e.getValue());
                continue;
            }
            this.attributes.remove(e.getName());
            if (this.session.getNativeSession() == null) continue;
            this.session.getNativeSession().setAttribute(e.getName(), null);
        }
        this.jvmOwnerId = in.readUTF();
    }
}

