/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpSession;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.modules.session.bootstrap.AbstractCache;
import org.apache.geode.modules.session.bootstrap.ClientServerCache;
import org.apache.geode.modules.session.bootstrap.LifecycleTypeAdapter;
import org.apache.geode.modules.session.bootstrap.PeerToPeerCache;
import org.apache.geode.modules.session.internal.common.CacheProperty;
import org.apache.geode.modules.session.internal.common.ClientServerSessionCache;
import org.apache.geode.modules.session.internal.common.PeerToPeerSessionCache;
import org.apache.geode.modules.session.internal.common.SessionCache;
import org.apache.geode.modules.session.internal.filter.Constants;
import org.apache.geode.modules.session.internal.filter.GemfireHttpSession;
import org.apache.geode.modules.session.internal.filter.SessionManager;
import org.apache.geode.modules.session.internal.filter.attributes.AbstractSessionAttributes;
import org.apache.geode.modules.session.internal.filter.attributes.DeltaQueuedSessionAttributes;
import org.apache.geode.modules.session.internal.filter.attributes.DeltaSessionAttributes;
import org.apache.geode.modules.session.internal.filter.attributes.ImmediateSessionAttributes;
import org.apache.geode.modules.session.internal.filter.util.TypeAwareMap;
import org.apache.geode.modules.session.internal.jmx.SessionStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GemfireSessionManager
implements SessionManager {
    private final Logger LOG;
    private static final String GEMFIRE_PROPERTY = "gemfire.property.";
    private static final String GEMFIRE_CACHE = "gemfire.cache.";
    private static final String INIT_PARAM_CACHE_TYPE = "cache-type";
    private static final String CACHE_TYPE_CLIENT_SERVER = "client-server";
    private static final String CACHE_TYPE_PEER_TO_PEER = "peer-to-peer";
    private static final String INIT_PARAM_SESSION_COOKIE_NAME = "session-cookie-name";
    private static final String INIT_PARAM_JVM_ID = "jvm-id";
    private static final String DEFAULT_JVM_ID = "default";
    private SessionCache sessionCache = null;
    private AbstractCache distributedCache = null;
    private boolean isStopping = false;
    private boolean isolated = false;
    private Map<String, String> nativeSessionMap = new HashMap<String, String>();
    private SessionStatistics mbean;
    private ClassLoader referenceClassLoader;
    private String sessionCookieName = "JSESSIONID";
    private String jvmId = "default";
    private TypeAwareMap<CacheProperty, Object> properties = new TypeAwareMap<CacheProperty, Object>(CacheProperty.class){
        {
            this.put(CacheProperty.REGION_NAME, "gemfire_modules_sessions");
            this.put(CacheProperty.ENABLE_GATEWAY_DELTA_REPLICATION, Boolean.FALSE);
            this.put(CacheProperty.ENABLE_GATEWAY_REPLICATION, Boolean.FALSE);
            this.put(CacheProperty.ENABLE_DEBUG_LISTENER, Boolean.FALSE);
            this.put(CacheProperty.STATISTICS_NAME, "gemfire_statistics");
            this.put(CacheProperty.SESSION_DELTA_POLICY, "delta_queued");
            this.put(CacheProperty.REPLICATION_TRIGGER, "set");
        }
    };

    public GemfireSessionManager() {
        this.LOG = LoggerFactory.getLogger((String)GemfireSessionManager.class.getName());
    }

    @Override
    public void start(Object conf, ClassLoader loader) {
        String sessionCookieName;
        this.referenceClassLoader = loader;
        FilterConfig config = (FilterConfig)conf;
        this.startDistributedSystem(config);
        this.initializeSessionCache(config);
        this.registerMBean();
        if (this.distributedCache.getClass().getClassLoader() == loader) {
            this.isolated = true;
        }
        if ((sessionCookieName = config.getInitParameter(INIT_PARAM_SESSION_COOKIE_NAME)) != null && !sessionCookieName.isEmpty()) {
            this.sessionCookieName = sessionCookieName;
            this.LOG.info("Session cookie name set to: {}", (Object)this.sessionCookieName);
        }
        this.jvmId = config.getInitParameter(INIT_PARAM_JVM_ID);
        if (this.jvmId == null || this.jvmId.isEmpty()) {
            this.jvmId = DEFAULT_JVM_ID;
        }
        this.LOG.info("Started GemfireSessionManager (isolated={}, jvmId={})", (Object)this.isolated, (Object)this.jvmId);
    }

    @Override
    public void stop() {
        this.isStopping = true;
        if (this.isolated) {
            if (this.distributedCache != null) {
                this.LOG.info("Closing distributed cache - assuming isolated cache");
                this.distributedCache.close();
            }
        } else {
            this.LOG.info("Not closing distributed cache - assuming common cache");
        }
    }

    @Override
    public HttpSession getSession(String id) {
        GemfireHttpSession session = (GemfireHttpSession)this.sessionCache.getOperatingRegion().get((Object)id);
        if (session != null) {
            if (session.justSerialized()) {
                session.setManager(this);
                this.LOG.debug("Recovered serialized session {} (jvmId={})", (Object)id, (Object)session.getJvmOwnerId());
            }
            this.LOG.debug("Retrieved session id {}", (Object)id);
        } else {
            this.LOG.debug("Session id {} not found", (Object)id);
        }
        return session;
    }

    @Override
    public HttpSession wrapSession(HttpSession nativeSession) {
        AbstractSessionAttributes attributes;
        String id = this.generateId();
        GemfireHttpSession session = new GemfireHttpSession(id, nativeSession);
        if ("delta_queued".equals(this.properties.get((Object)CacheProperty.SESSION_DELTA_POLICY))) {
            attributes = new DeltaQueuedSessionAttributes();
            attributes.setReplicationTrigger((String)this.properties.get((Object)CacheProperty.REPLICATION_TRIGGER));
        } else if ("delta_immediate".equals(this.properties.get((Object)CacheProperty.SESSION_DELTA_POLICY))) {
            attributes = new DeltaSessionAttributes();
        } else if ("immediate".equals(this.properties.get((Object)CacheProperty.SESSION_DELTA_POLICY))) {
            attributes = new ImmediateSessionAttributes();
        } else {
            attributes = new DeltaSessionAttributes();
            this.LOG.warn("No session delta policy specified - using default of 'delta_immediate'");
        }
        attributes.setSession(session);
        attributes.setJvmOwnerId(this.jvmId);
        session.setManager(this);
        session.setAttributes(attributes);
        this.LOG.debug("Creating new session {}", (Object)id);
        this.sessionCache.getOperatingRegion().put((Object)id, (Object)session);
        this.mbean.incActiveSessions();
        return session;
    }

    @Override
    public HttpSession getWrappingSession(String nativeId) {
        HttpSession session = null;
        String gemfireId = this.getGemfireSessionIdFromNativeId(nativeId);
        if (gemfireId != null) {
            session = this.getSession(gemfireId);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(String id) {
        GemfireHttpSession session2;
        if (!this.isStopping) {
            try {
                session2 = (GemfireHttpSession)this.sessionCache.getOperatingRegion().get((Object)id);
                if (session2 != null && session2.getJvmOwnerId().equals(this.jvmId)) {
                    this.LOG.debug("Destroying session {}", (Object)id);
                    this.sessionCache.getOperatingRegion().destroy((Object)id);
                    this.mbean.decActiveSessions();
                }
            }
            catch (EntryNotFoundException session2) {}
        } else if (this.sessionCache.isClientServer()) {
            this.LOG.debug("Destroying session {}", (Object)id);
            try {
                this.sessionCache.getOperatingRegion().localDestroy((Object)id);
            }
            catch (EntryNotFoundException session2) {
            }
            catch (CacheClosedException session2) {}
        } else {
            session2 = (GemfireHttpSession)this.sessionCache.getOperatingRegion().get((Object)id);
            if (session2 != null) {
                session2.setNativeSession(null);
            }
        }
        Map<String, String> map = this.nativeSessionMap;
        synchronized (map) {
            String nativeId = this.nativeSessionMap.remove(id);
            this.LOG.debug("destroySession called for {} wrapping {}", (Object)id, (Object)nativeId);
        }
    }

    @Override
    public void putSession(HttpSession session) {
        this.sessionCache.getOperatingRegion().put((Object)session.getId(), (Object)session);
        this.mbean.incRegionUpdates();
        this.nativeSessionMap.put(session.getId(), ((GemfireHttpSession)session).getNativeSession().getId());
    }

    @Override
    public String destroyNativeSession(String nativeId) {
        String gemfireSessionId = this.getGemfireSessionIdFromNativeId(nativeId);
        if (gemfireSessionId != null) {
            this.destroySession(gemfireSessionId);
        }
        return gemfireSessionId;
    }

    public ClassLoader getReferenceClassLoader() {
        return this.referenceClassLoader;
    }

    public String refreshSession(String nativeId) {
        String gemfireId = this.getGemfireSessionIdFromNativeId(nativeId);
        if (gemfireId == null) {
            return null;
        }
        GemfireHttpSession session = (GemfireHttpSession)this.sessionCache.getOperatingRegion().get((Object)gemfireId);
        if (session.isValid()) {
            // empty if block
        }
        return null;
    }

    @Override
    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    @Override
    public String getJvmId() {
        return this.jvmId;
    }

    private String getGemfireSessionIdFromNativeId(String nativeId) {
        if (nativeId == null) {
            return null;
        }
        for (Map.Entry<String, String> e : this.nativeSessionMap.entrySet()) {
            if (!nativeId.equals(e.getValue())) continue;
            return e.getKey();
        }
        return null;
    }

    private void startDistributedSystem(FilterConfig config) {
        String cacheType = config.getInitParameter(INIT_PARAM_CACHE_TYPE);
        if (CACHE_TYPE_CLIENT_SERVER.equals(cacheType)) {
            this.distributedCache = ClientServerCache.getInstance();
        } else if (CACHE_TYPE_PEER_TO_PEER.equals(cacheType)) {
            this.distributedCache = PeerToPeerCache.getInstance();
        } else {
            this.LOG.error("No 'cache-type' initialization param set. Cache will not be started");
            return;
        }
        if (!this.distributedCache.isStarted()) {
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                if (!param.startsWith(GEMFIRE_PROPERTY)) continue;
                String gemfireProperty = param.substring(GEMFIRE_PROPERTY.length());
                this.LOG.info("Setting gemfire property: {} = {}", (Object)gemfireProperty, (Object)config.getInitParameter(param));
                this.distributedCache.setProperty(gemfireProperty, config.getInitParameter(param));
            }
            this.distributedCache.lifecycleEvent(LifecycleTypeAdapter.START);
        }
    }

    private void initializeSessionCache(FilterConfig config) {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (cache == null) {
            throw new IllegalStateException("No cache exists. Please configure either a PeerToPeerCacheLifecycleListener or ClientServerCacheLifecycleListener in the server.xml file.");
        }
        InternalResourceManager rm = cache.getResourceManager();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            float val;
            String param = (String)e.nextElement();
            if (param.equalsIgnoreCase("criticalHeapPercentage")) {
                val = Float.parseFloat(config.getInitParameter(param));
                rm.setCriticalHeapPercentage(val);
            }
            if (param.equalsIgnoreCase("evictionHeapPercentage")) {
                val = Float.parseFloat(config.getInitParameter(param));
                rm.setEvictionHeapPercentage(val);
            }
            if (!param.startsWith(GEMFIRE_CACHE)) continue;
            String gemfireWebParam = param.substring(GEMFIRE_CACHE.length());
            this.LOG.info("Setting cache parameter: {} = {}", (Object)gemfireWebParam, (Object)config.getInitParameter(param));
            this.properties.put(CacheProperty.valueOf(gemfireWebParam.toUpperCase()), config.getInitParameter(param));
        }
        this.sessionCache = cache.isClient() ? new ClientServerSessionCache((ClientCache)cache, this.properties) : new PeerToPeerSessionCache((Cache)cache, this.properties);
        this.sessionCache.initialize();
    }

    private void registerMBean() {
        this.mbean = new SessionStatistics();
        try {
            InitialContext ctx = new InitialContext();
            MBeanServer mbs = (MBeanServer)MBeanServer.class.cast(ctx.lookup("java:comp/env/jmx/runtime"));
            ObjectName oname = new ObjectName(Constants.SESSION_STATISTICS_MBEAN_NAME);
            mbs.registerMBean(this.mbean, oname);
        }
        catch (Exception ex) {
            this.LOG.warn("Unable to register statistics MBean. Error: {}", (Object)ex.getMessage());
        }
    }

    private String generateId() {
        return UUID.randomUUID().toString().toUpperCase() + "-GF";
    }

    AbstractCache getCache() {
        return this.distributedCache;
    }
}

