/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.common;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.modules.session.internal.common.AbstractSessionCache;
import org.apache.geode.modules.session.internal.common.CacheProperty;
import org.apache.geode.modules.session.internal.common.PeerToPeerSessionCache;
import org.apache.geode.modules.util.BootstrappingFunction;
import org.apache.geode.modules.util.RegionConfiguration;
import org.apache.geode.modules.util.RegionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServerSessionCache
extends AbstractSessionCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)PeerToPeerSessionCache.class.getName());
    private ClientCache cache;
    protected static final String DEFAULT_REGION_ATTRIBUTES_ID = RegionShortcut.PARTITION_REDUNDANT.toString();
    protected static final Boolean DEFAULT_ENABLE_LOCAL_CACHE = true;

    public ClientServerSessionCache(ClientCache cache, Map<CacheProperty, Object> properties) {
        this.cache = cache;
        this.properties.put(CacheProperty.REGION_ATTRIBUTES_ID, DEFAULT_REGION_ATTRIBUTES_ID);
        this.properties.put(CacheProperty.ENABLE_LOCAL_CACHE, DEFAULT_ENABLE_LOCAL_CACHE);
        this.properties.putAll(properties);
    }

    @Override
    public void initialize() {
        this.bootstrapServers();
        this.createOrRetrieveRegion();
        this.operatingRegion = this.sessionRegion;
        this.createStatistics();
    }

    @Override
    public GemFireCache getCache() {
        return this.cache;
    }

    @Override
    public boolean isClientServer() {
        return true;
    }

    private void bootstrapServers() {
        Execution execution = FunctionService.onServers((RegionService)this.cache);
        ResultCollector collector = execution.execute((Function)new BootstrappingFunction());
        try {
            collector.getResult();
        }
        catch (Exception e) {
            LOG.warn("Caught unexpected exception:", (Throwable)e);
        }
    }

    private void createOrRetrieveRegion() {
        this.sessionRegion = this.cache.getRegion((String)this.properties.get((Object)CacheProperty.REGION_NAME));
        if (this.sessionRegion == null) {
            this.createSessionRegionOnServers();
            this.sessionRegion = this.createLocalSessionRegion();
            LOG.debug("Created session region: " + this.sessionRegion);
        } else {
            LOG.debug("Retrieved session region: " + this.sessionRegion);
        }
    }

    private void createSessionRegionOnServers() {
        RegionConfiguration configuration = this.createRegionConfiguration();
        Execution execution = FunctionService.onServer((RegionService)this.cache).withArgs((Object)configuration);
        ResultCollector collector = execution.execute("create-region-function");
        List results = (List)collector.getResult();
        for (RegionStatus status : results) {
            if (status != RegionStatus.INVALID) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("An exception occurred on the server while attempting to create or validate region named ");
            builder.append(this.properties.get((Object)CacheProperty.REGION_NAME));
            builder.append(". See the server log for additional details.");
            throw new IllegalStateException(builder.toString());
        }
    }

    private Region<String, HttpSession> createLocalSessionRegion() {
        ClientRegionFactory factory = null;
        boolean enableLocalCache = (Boolean)this.properties.get((Object)CacheProperty.ENABLE_LOCAL_CACHE);
        String regionName = (String)this.properties.get((Object)CacheProperty.REGION_NAME);
        if (enableLocalCache) {
            factory = this.cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY_HEAP_LRU);
            LOG.info("Created new local client session region: {}", (Object)regionName);
        } else {
            factory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
            LOG.info("Created new local client (uncached) session region: {} without any session expiry", (Object)regionName);
        }
        return factory.create(regionName);
    }
}

