/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached;

import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.memcached.GemFireMemcachedServer;
import org.apache.logging.log4j.Logger;

public class GeodeMemcachedService
implements CacheService {
    private static final Logger logger = LogService.getLogger();
    private GemFireMemcachedServer memcachedServer;

    public void init(Cache cache) {
        InternalCache internalCache = (InternalCache)cache;
        this.startMemcachedServer(internalCache);
    }

    private void startMemcachedServer(InternalCache internalCache) {
        InternalDistributedSystem system = internalCache.getInternalDistributedSystem();
        int port = system.getConfig().getMemcachedPort();
        if (port != 0) {
            String protocol = system.getConfig().getMemcachedProtocol();
            assert (protocol != null);
            String bindAddress = system.getConfig().getMemcachedBindAddress();
            assert (bindAddress != null);
            if (bindAddress.equals("")) {
                logger.info("Starting GemFireMemcachedServer on port {} for {} protocol", new Object[]{port, protocol});
            } else {
                logger.info("Starting GemFireMemcachedServer on bind address {} on port {} for {} protocol", new Object[]{bindAddress, port, protocol});
            }
            this.memcachedServer = new GemFireMemcachedServer(bindAddress, port, GemFireMemcachedServer.Protocol.valueOf(protocol.toUpperCase()));
            this.memcachedServer.start();
        }
    }

    public void close() {
        this.stopMemcachedServer();
    }

    private void stopMemcachedServer() {
        if (this.memcachedServer != null) {
            logger.info("GemFireMemcachedServer is shutting down");
            this.memcachedServer.shutdown();
        }
    }

    public Class<? extends CacheService> getInterface() {
        return GeodeMemcachedService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }
}

