/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.ObjectType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionType;
import org.apache.geode.management.api.CorrespondWith;
import org.apache.geode.management.api.RestfulEndpoint;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.geode.management.runtime.RuntimeRegionInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="region-type", namespace="http://geode.apache.org/schema/cache", propOrder={"regionAttributes", "indexes", "entries", "regionElements", "regions"})
@Experimental
public class RegionConfig
extends CacheElement
implements RestfulEndpoint,
CorrespondWith<RuntimeRegionInfo> {
    public static final String REGION_CONFIG_ENDPOINT = "/regions";
    @XmlElement(name="region-attributes", namespace="http://geode.apache.org/schema/cache")
    protected RegionAttributesType regionAttributes;
    @XmlElement(name="index", namespace="http://geode.apache.org/schema/cache")
    protected List<Index> indexes;
    @ApiModelProperty(hidden=true)
    @XmlElement(name="entry", namespace="http://geode.apache.org/schema/cache")
    protected List<Entry> entries;
    @XmlAnyElement(lax=true)
    protected List<CacheElement> regionElements;
    @ApiModelProperty(hidden=true)
    @XmlElement(name="region", namespace="http://geode.apache.org/schema/cache")
    protected List<RegionConfig> regions;
    @XmlAttribute(name="name", required=true)
    protected String name;
    @XmlAttribute(name="refid")
    protected String type;

    public RegionConfig() {
    }

    public RegionConfig(String name, String refid) {
        this.name = name;
        this.type = refid;
    }

    public RegionConfig(RegionConfig config) {
        this.regionAttributes = config.getRegionAttributes();
        this.type = config.getType();
        this.entries = config.getEntries();
        this.indexes = config.getIndexes();
        this.name = config.getName();
        this.regionElements = config.getCustomRegionElements();
        this.regions = config.getRegions();
        this.setGroup(config.getGroup());
    }

    @Override
    public boolean isGlobalRuntime() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getEndpoint() {
        return REGION_CONFIG_ENDPOINT;
    }

    public RegionAttributesType getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setRegionAttributes(RegionAttributesType regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    public List<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<Index>();
        }
        return this.indexes;
    }

    public List<Entry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        return this.entries;
    }

    @ApiModelProperty(hidden=true)
    public List<CacheElement> getCustomRegionElements() {
        if (this.regionElements == null) {
            this.regionElements = new ArrayList<CacheElement>();
        }
        return this.regionElements;
    }

    public List<RegionConfig> getRegions() {
        if (this.regions == null) {
            this.regions = new ArrayList<RegionConfig>();
        }
        return this.regions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws IllegalArgumentException {
        boolean hasSubRegions;
        if (value == null) {
            return;
        }
        boolean regionPrefixedWithSlash = value.startsWith("/");
        String[] regionSplit = value.split("/");
        boolean bl = regionPrefixedWithSlash ? regionSplit.length > 2 : (hasSubRegions = regionSplit.length > 1);
        if (hasSubRegions) {
            throw new IllegalArgumentException("Sub-regions are unsupported");
        }
        this.name = regionPrefixedWithSlash ? regionSplit[1] : value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(RegionType regionType) {
        if (regionType != null) {
            this.setType(regionType.name());
        }
    }

    public void setType(String regionType) {
        if (regionType != null) {
            this.type = regionType.toUpperCase();
        }
    }

    @JsonIgnore
    public String getId() {
        return this.getName();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        RegionConfig config = (RegionConfig)that;
        return Objects.equals(this.getName(), config.getName()) && Objects.equals(this.getType(), config.getType());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Index
    extends CacheElement
    implements RestfulEndpoint,
    CorrespondWith<RuntimeInfo> {
        @XmlAttribute(name="name", required=true)
        protected String name;
        @XmlAttribute(name="expression")
        protected String expression;
        @XmlAttribute(name="from-clause")
        protected String fromClause;
        @XmlAttribute(name="imports")
        protected String imports;
        @XmlAttribute(name="key-index")
        protected Boolean keyIndex;
        @XmlAttribute(name="type")
        protected String type;
        @XmlTransient
        protected String regionName;

        public Index() {
        }

        public Index(Index index) {
            this.name = index.name;
            this.expression = index.expression;
            this.fromClause = index.fromClause;
            this.imports = index.imports;
            this.keyIndex = index.keyIndex;
            this.type = index.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String value) {
            this.expression = value;
        }

        public String getFromClause() {
            return this.fromClause;
        }

        public void setFromClause(String value) {
            this.fromClause = value;
        }

        public String getImports() {
            return this.imports;
        }

        public void setImports(String value) {
            this.imports = value;
        }

        public Boolean isKeyIndex() {
            return this.keyIndex;
        }

        public void setKeyIndex(Boolean value) {
            this.keyIndex = value;
        }

        public String getType() {
            if (this.keyIndex == Boolean.TRUE) {
                return "key";
            }
            if (this.type == null) {
                return "range";
            }
            return this.type;
        }

        public void setType(String value) {
            if ("range".equalsIgnoreCase(value) || "hash".equalsIgnoreCase(value)) {
                this.type = value.toLowerCase();
                this.setKeyIndex(false);
            } else if ("key".equalsIgnoreCase(value)) {
                this.type = null;
                this.setKeyIndex(true);
            } else {
                throw new IllegalArgumentException("Invalid index type " + value);
            }
        }

        public String getRegionName() {
            return this.regionName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
            if (StringUtils.isBlank((CharSequence)regionName)) {
                return;
            }
            if (this.fromClause == null) {
                this.fromClause = "/" + regionName;
            } else if (!this.fromClause.contains(regionName)) {
                throw new IllegalArgumentException("Invalid regionName for this index with fromClause = " + this.fromClause);
            }
        }

        @JsonIgnore
        public String getId() {
            return this.getName();
        }

        @Override
        public String getEndpoint() {
            if (StringUtils.isBlank((CharSequence)this.regionName)) {
                return null;
            }
            return "/regions/" + this.regionName + "/indexes";
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"key", "value"})
    public static class Entry
    implements Serializable {
        @XmlElement(namespace="http://geode.apache.org/schema/cache", required=true)
        protected ObjectType key;
        @XmlElement(namespace="http://geode.apache.org/schema/cache", required=true)
        protected ObjectType value;

        public Entry() {
        }

        public Entry(String key, String value) {
            this.key = new ObjectType(key);
            this.value = new ObjectType(value);
        }

        public Entry(ObjectType key, ObjectType value) {
            this.key = key;
            this.value = value;
        }

        public ObjectType getKey() {
            return this.key;
        }

        public void setKey(ObjectType value) {
            this.key = value;
        }

        public ObjectType getValue() {
            return this.value;
        }

        public void setValue(ObjectType value) {
            this.value = value;
        }
    }
}

