/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.directory.DumpDirectoryFiles;
import org.apache.geode.cache.lucene.internal.filesystem.ChunkKey;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystemStats;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import org.apache.geode.internal.cache.PartitionedRegion;

public class LuceneIndexForPartitionedRegion
extends LuceneIndexImpl {
    protected Region<String, File> fileRegion;
    protected Region<ChunkKey, byte[]> chunkRegion;
    protected final FileSystemStats fileSystemStats;

    public LuceneIndexForPartitionedRegion(String indexName, String regionPath, Cache cache) {
        super(indexName, regionPath, cache);
        String statsName = indexName + "-" + regionPath;
        this.fileSystemStats = new FileSystemStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    protected RepositoryManager createRepositoryManager() {
        String chunkRegionName;
        boolean withStorage;
        boolean withPersistence = this.withPersistence();
        RegionAttributes regionAttributes = this.dataRegion.getAttributes();
        boolean bl = withStorage = regionAttributes.getPartitionAttributes().getLocalMaxMemory() > 0;
        if (!withStorage) {
            throw new IllegalStateException("The data region to create lucene index should be with storage");
        }
        RegionShortcut regionShortCut = withPersistence ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION;
        String fileRegionName = this.createFileRegionName();
        PartitionAttributes partitionAttributes = this.dataRegion.getPartitionAttributes();
        if (!this.fileRegionExists(fileRegionName)) {
            this.fileRegion = this.createFileRegion(regionShortCut, fileRegionName, partitionAttributes, regionAttributes);
        }
        if (!this.chunkRegionExists(chunkRegionName = this.createChunkRegionName())) {
            this.chunkRegion = this.createChunkRegion(regionShortCut, fileRegionName, partitionAttributes, chunkRegionName, regionAttributes);
        }
        this.fileSystemStats.setFileSupplier(() -> (int)this.getFileRegion().getLocalSize());
        this.fileSystemStats.setChunkSupplier(() -> (int)this.getChunkRegion().getLocalSize());
        this.fileSystemStats.setBytesSupplier(() -> this.getChunkRegion().getPrStats().getDataStoreBytesInUse());
        HeterogeneousLuceneSerializer mapper = new HeterogeneousLuceneSerializer(this.getFieldNames());
        return new PartitionedRepositoryManager(this, mapper);
    }

    public PartitionedRegion getFileRegion() {
        return (PartitionedRegion)this.fileRegion;
    }

    public PartitionedRegion getChunkRegion() {
        return (PartitionedRegion)this.chunkRegion;
    }

    public FileSystemStats getFileSystemStats() {
        return this.fileSystemStats;
    }

    boolean fileRegionExists(String fileRegionName) {
        return this.cache.getRegion(fileRegionName) != null;
    }

    Region createFileRegion(RegionShortcut regionShortCut, String fileRegionName, PartitionAttributes partitionAttributes, RegionAttributes regionAttributes) {
        return this.createRegion(fileRegionName, regionShortCut, this.regionPath, partitionAttributes, regionAttributes);
    }

    public String createFileRegionName() {
        return LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath) + ".files";
    }

    boolean chunkRegionExists(String chunkRegionName) {
        return this.cache.getRegion(chunkRegionName) != null;
    }

    Region<ChunkKey, byte[]> createChunkRegion(RegionShortcut regionShortCut, String fileRegionName, PartitionAttributes partitionAttributes, String chunkRegionName, RegionAttributes regionAttributes) {
        return this.createRegion(chunkRegionName, regionShortCut, fileRegionName, partitionAttributes, regionAttributes);
    }

    public String createChunkRegionName() {
        return LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath) + ".chunks";
    }

    private PartitionAttributesFactory configureLuceneRegionAttributesFactory(PartitionAttributesFactory attributesFactory, PartitionAttributes<?, ?> dataRegionAttributes) {
        attributesFactory.setTotalNumBuckets(dataRegionAttributes.getTotalNumBuckets());
        attributesFactory.setRedundantCopies(dataRegionAttributes.getRedundantCopies());
        return attributesFactory;
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionShortcut regionShortCut, String colocatedWithRegionName, PartitionAttributes partitionAttributes, RegionAttributes regionAttributes) {
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory();
        partitionAttributesFactory.setColocatedWith(colocatedWithRegionName);
        this.configureLuceneRegionAttributesFactory(partitionAttributesFactory, partitionAttributes);
        RegionAttributes baseAttributes = this.cache.getRegionAttributes(regionShortCut.toString());
        AttributesFactory factory = new AttributesFactory(baseAttributes);
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        factory.setDiskStoreName(regionAttributes.getDiskStoreName());
        RegionAttributes attributes = factory.create();
        return this.createRegion(regionName, attributes);
    }

    public void close() {
    }

    @Override
    public void dumpFiles(String directory) {
        ResultCollector results = FunctionService.onRegion((Region)this.getDataRegion()).withArgs((Object)new String[]{directory, this.indexName}).execute(DumpDirectoryFiles.ID);
        results.getResult();
    }
}

