/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.Serializable;
import org.apache.geode.test.junit.Retry;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule
implements TestRule,
Serializable {
    private static final boolean LOG = false;
    private final AbstractRetryRule implementation;

    public RetryRule() {
        this.implementation = new LocalRetryRule();
    }

    public RetryRule(int retryCount) {
        this.implementation = new GlobalRetryRule(retryCount);
    }

    public Statement apply(Statement base, Description description) {
        return this.implementation.apply(base, description);
    }

    protected class LocalRetryRule
    extends AbstractRetryRule {
        protected LocalRetryRule() {
        }

        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    LocalRetryRule.this.evaluatePerTest(base, description);
                }
            };
        }

        protected void evaluatePerTest(Statement base, Description description) throws Throwable {
            if (this.isTest(description)) {
                Retry retry = (Retry)description.getAnnotation(Retry.class);
                int retryCount = this.getRetryCount(retry);
                this.evaluate(base, description, retryCount);
            }
        }

        private int getRetryCount(Retry retry) {
            int retryCount = 1;
            if (retry != null) {
                retryCount = retry.value();
            }
            return retryCount;
        }

        private boolean isTest(Description description) {
            return description.isSuite() || description.isTest();
        }
    }

    protected class GlobalRetryRule
    extends AbstractRetryRule {
        private final int retryCount;

        protected GlobalRetryRule(int retryCount) {
            if (retryCount < 1) {
                throw new IllegalArgumentException("Retry count must be greater than zero");
            }
            this.retryCount = retryCount;
        }

        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    GlobalRetryRule.this.evaluatePerCase(base, description);
                }
            };
        }

        protected void evaluatePerCase(Statement base, Description description) throws Throwable {
            this.evaluate(base, description, this.retryCount);
        }
    }

    protected abstract class AbstractRetryRule
    implements TestRule,
    Serializable {
        protected AbstractRetryRule() {
        }

        protected void evaluate(Statement base, Description description, int retryCount) throws Throwable {
            if (retryCount == 0) {
                // empty if block
            }
            Throwable caughtThrowable = null;
            for (int count = 0; count < retryCount; ++count) {
                try {
                    base.evaluate();
                    return;
                }
                catch (Throwable t) {
                    caughtThrowable = t;
                    this.debug(description.getDisplayName() + ": run " + (count + 1) + " failed");
                    continue;
                }
            }
            this.debug(description.getDisplayName() + ": giving up after " + retryCount + " failures");
            throw caughtThrowable;
        }

        private void debug(String message) {
        }
    }
}

