/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import joptsimple.ArgumentList;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ParserRules;

abstract class OptionParserState {
    OptionParserState() {
    }

    static OptionParserState noMoreOptions() {
        return new OptionParserState(){

            @Override
            protected void handleArgument(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions) {
                detectedOptions.addNonOptionArgument(arguments.next());
            }
        };
    }

    static OptionParserState moreOptions(final boolean posixlyCorrect) {
        return new OptionParserState(){

            @Override
            protected void handleArgument(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions) {
                String candidate = arguments.next();
                if (ParserRules.isOptionTerminator(candidate)) {
                    parser.noMoreOptions();
                } else if (ParserRules.isLongOptionToken(candidate)) {
                    parser.handleLongOptionToken(candidate, arguments, detectedOptions);
                } else if (!parser.isShortOptionDisabled() && ParserRules.isShortOptionToken(candidate)) {
                    parser.handleShortOptionToken(candidate, arguments, detectedOptions);
                } else {
                    if (posixlyCorrect) {
                        parser.noMoreOptions();
                    }
                    if (!parser.isShortOptionDisabled() || !candidate.equals("-") && !candidate.equals("--")) {
                        detectedOptions.addNonOptionArgument(candidate);
                    }
                }
            }
        };
    }

    protected abstract void handleArgument(OptionParser var1, ArgumentList var2, OptionSet var3);
}

