/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.TraceScope;
import org.apache.cxf.tracing.opentracing.internal.TextMapInjectAdapter;

public abstract class AbstractOpenTracingClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOpenTracingClientProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.client.opentracing.span";
    private final Tracer tracer;

    public AbstractOpenTracingClientProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        Span parent = this.tracer.activeSpan();
        Span activeSpan = null;
        Scope scope = null;
        if (parent == null) {
            activeSpan = this.tracer.buildSpan(this.buildSpanDescription(uri.toString(), method)).start();
            scope = this.tracer.scopeManager().activate(activeSpan);
        } else {
            activeSpan = this.tracer.buildSpan(this.buildSpanDescription(uri.toString(), method)).asChildOf(parent).start();
            scope = this.tracer.scopeManager().activate(activeSpan);
        }
        activeSpan.setTag(Tags.HTTP_METHOD.getKey(), method);
        activeSpan.setTag(Tags.HTTP_URL.getKey(), uri.toString());
        this.tracer.inject(activeSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(requestHeaders));
        Span span = null;
        if (this.isAsyncInvocation()) {
            span = activeSpan;
            scope.close();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(activeSpan, scope), span != null);
    }

    private boolean isAsyncInvocation() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, int responseStatus) {
        if (holder == null) {
            return;
        }
        TraceScope traceScope = (TraceScope)holder.getScope();
        if (traceScope != null) {
            Span span = traceScope.getSpan();
            Scope scope = traceScope.getScope();
            if (holder.isDetached()) {
                scope = this.tracer.scopeManager().activate(span);
            }
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)responseStatus);
            span.finish();
            scope.close();
        }
    }
}

