/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.ActiveSpan;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.TraceScope;

public abstract class AbstractOpenTracingProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOpenTracingProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.opentracing.span";
    protected final Tracer tracer;

    protected AbstractOpenTracingProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        SpanContext parent = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(requestHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::getFirstValueOrEmpty))));
        ActiveSpan scope = null;
        scope = parent == null ? this.tracer.buildSpan(this.buildSpanDescription(uri.getPath(), method)).startActive() : this.tracer.buildSpan(this.buildSpanDescription(uri.getPath(), method)).asChildOf(parent).startActive();
        scope.setTag(Tags.HTTP_METHOD.getKey(), method);
        scope.setTag(Tags.HTTP_URL.getKey(), uri.toString());
        ActiveSpan.Continuation continuation = null;
        if (this.isAsyncResponse()) {
            continuation = scope.capture();
            this.propagateContinuationSpan(continuation);
            scope.deactivate();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(scope, continuation), continuation != null);
    }

    protected void stopTraceSpan(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, int responseStatus, AbstractTracingProvider.TraceScopeHolder<TraceScope> holder) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            ActiveSpan span = scope.getSpan();
            if (holder.isDetached()) {
                span = scope.getContinuation().activate();
            }
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)responseStatus);
            span.close();
        }
    }

    protected boolean isAsyncResponse() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    private void propagateContinuationSpan(ActiveSpan.Continuation continuationScope) {
        PhaseInterceptorChain.getCurrentMessage().put(ActiveSpan.Continuation.class, (Object)continuationScope);
    }

    private String getFirstValueOrEmpty(Map.Entry<String, List<String>> entry) {
        List<String> values = entry.getValue();
        if (values == null || values.isEmpty()) {
            return "";
        }
        String value = values.get(0);
        return value != null ? value : "";
    }
}

