/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed.obj;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.SimpleTriangleMesh;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.examples.io.threed.obj.OBJConstants;

public final class OBJReader {
    private static final int BUFFER_SIZE = 2048;
    private SimpleTriangleMesh.Builder meshBuilder;

    public TriangleMesh readTriangleMesh(File file, DoublePrecisionContext precision) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), OBJConstants.DEFAULT_CHARSET);){
            TriangleMesh triangleMesh = this.readTriangleMesh(reader, precision);
            return triangleMesh;
        }
    }

    public TriangleMesh readTriangleMesh(URL url, DoublePrecisionContext precision) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream(), OBJConstants.DEFAULT_CHARSET);){
            TriangleMesh triangleMesh = this.readTriangleMesh(reader, precision);
            return triangleMesh;
        }
    }

    public TriangleMesh readTriangleMesh(Reader reader, DoublePrecisionContext precision) throws IOException {
        this.meshBuilder = SimpleTriangleMesh.builder((DoublePrecisionContext)precision);
        this.parse(reader);
        SimpleTriangleMesh mesh = this.meshBuilder.build();
        this.meshBuilder = null;
        return mesh;
    }

    private void parse(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[2048];
        StringBuilder sb = new StringBuilder();
        while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
            for (int i = 0; i < read; ++i) {
                char ch = buffer[i];
                if (ch == '\r' || ch == '\n') {
                    if (sb.length() <= 0) continue;
                    this.parseLine(sb.toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(ch);
            }
        }
        if (sb.length() > 0) {
            this.parseLine(sb.toString());
        }
    }

    private void parseLine(String line) {
        int startIdx;
        for (startIdx = 0; startIdx < line.length() && Character.isWhitespace(line.charAt(startIdx)); ++startIdx) {
        }
        if (startIdx >= line.length() || line.charAt(startIdx) == '#') {
            return;
        }
        int idx = this.nextWhitespace(line, startIdx);
        if (idx > -1) {
            String keyword = line.substring(startIdx, idx);
            String remainder = line.substring(idx + 1).trim();
            if ("v".equals(keyword)) {
                this.parseVertexLine(remainder);
            } else if ("f".equals(keyword)) {
                this.parseFaceLine(remainder);
            }
        }
    }

    private void parseVertexLine(String line) {
        String[] parts = this.splitOnWhitespace(line);
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid vertex definition: at least 3 fields required but found only " + parts.length);
        }
        double x = Double.parseDouble(parts[0]);
        double y = Double.parseDouble(parts[1]);
        double z = Double.parseDouble(parts[2]);
        this.addVertex(Vector3D.of((double)x, (double)y, (double)z));
    }

    private void addVertex(Vector3D vertex) {
        this.meshBuilder.addVertex(vertex);
    }

    private void parseFaceLine(String line) {
        String[] parts = this.splitOnWhitespace(line);
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid face definition: at least 3 fields required but found only " + parts.length);
        }
        int startIdx = this.parseFaceVertexIndex(parts[0]);
        int prevIdx = this.parseFaceVertexIndex(parts[1]);
        for (int i = 2; i < parts.length; ++i) {
            int curIdx = this.parseFaceVertexIndex(parts[i]);
            this.addFace(startIdx, prevIdx, curIdx);
            prevIdx = curIdx;
        }
    }

    private int parseFaceVertexIndex(String str) {
        int sepIdx = str.indexOf(47);
        String vertexIdxStr = sepIdx > -1 ? str.substring(0, sepIdx) : str;
        return Integer.parseInt(vertexIdxStr);
    }

    private void addFace(int index1, int index2, int index3) {
        this.meshBuilder.addFace(this.adjustVertexIndex(index1), this.adjustVertexIndex(index2), this.adjustVertexIndex(index3));
    }

    private int adjustVertexIndex(int index) {
        if (index < 0) {
            return this.meshBuilder.getVertexCount() + index;
        }
        return index - 1;
    }

    private int nextWhitespace(String str, int startIdx) {
        int len = str.length();
        for (int i = startIdx; i < len; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private String[] splitOnWhitespace(String str) {
        return str.split("\\s+");
    }
}

