/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed.obj;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.examples.io.threed.AbstractModelIOHandler;
import org.apache.commons.geometry.examples.io.threed.obj.OBJReader;
import org.apache.commons.geometry.examples.io.threed.obj.OBJWriter;

public class OBJModelIOHandler
extends AbstractModelIOHandler {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    @Override
    public boolean handlesType(String type) {
        return "obj".equalsIgnoreCase(type);
    }

    protected TriangleMesh readInternal(String type, InputStream in, DoublePrecisionContext precision) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, DEFAULT_CHARSET);){
            OBJReader objReader = new OBJReader();
            TriangleMesh triangleMesh = objReader.readTriangleMesh(reader, precision);
            return triangleMesh;
        }
    }

    @Override
    protected void writeInternal(BoundarySource3D model, String type, OutputStream out) throws IOException {
        try (OBJWriter objWriter = new OBJWriter(new BufferedWriter(new OutputStreamWriter(out, DEFAULT_CHARSET)));){
            objWriter.writeBoundaries(model);
        }
    }
}

