/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.examples.io.threed.ModelIOHandler;

public class ModelIOHandlerRegistry
implements ModelIOHandler {
    private final List<ModelIOHandler> handlers = new ArrayList<ModelIOHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelIOHandler getHandlerForType(String type) {
        List<ModelIOHandler> list = this.handlers;
        synchronized (list) {
            for (ModelIOHandler handler : this.handlers) {
                if (!handler.handlesType(type)) continue;
                return handler;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModelIOHandler> getHandlers() {
        List<ModelIOHandler> list = this.handlers;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<ModelIOHandler>(this.handlers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandlers(List<ModelIOHandler> newHandlers) {
        List<ModelIOHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.clear();
            if (newHandlers != null) {
                this.handlers.addAll(newHandlers);
            }
        }
    }

    @Override
    public boolean handlesType(String type) {
        return this.getHandlerForType(type) != null;
    }

    public BoundarySource3D read(File in, DoublePrecisionContext precision) {
        return this.read(this.getFileExtension(in), in, precision);
    }

    @Override
    public BoundarySource3D read(String type, File in, DoublePrecisionContext precision) {
        return this.requireHandlerForType(type).read(type, in, precision);
    }

    @Override
    public BoundarySource3D read(String type, InputStream in, DoublePrecisionContext precision) {
        return this.requireHandlerForType(type).read(type, in, precision);
    }

    public void write(BoundarySource3D model, File out) {
        this.write(model, this.getFileExtension(out), out);
    }

    @Override
    public void write(BoundarySource3D model, String type, File out) {
        this.requireHandlerForType(type).write(model, type, out);
    }

    @Override
    public void write(BoundarySource3D model, String type, OutputStream out) {
        this.requireHandlerForType(type).write(model, type, out);
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        if (idx > -1) {
            return name.substring(idx + 1).toLowerCase();
        }
        throw new IllegalArgumentException("Cannot determine target file type: \"" + file + "\" does not have a file extension");
    }

    private ModelIOHandler requireHandlerForType(String type) {
        ModelIOHandler handler = this.getHandlerForType(type);
        if (handler == null) {
            throw new IllegalArgumentException("No handler found for type \"" + type + "\"");
        }
        return handler;
    }
}

