/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed.obj;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.regex.Pattern;
import org.apache.commons.geometry.core.GeometryTestUtils;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.Mesh;
import org.apache.commons.geometry.euclidean.threed.mesh.SimpleTriangleMesh;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.euclidean.threed.shape.Parallelepiped;
import org.apache.commons.geometry.euclidean.threed.shape.Sphere;
import org.apache.commons.geometry.examples.io.threed.obj.OBJReaderTest;
import org.apache.commons.geometry.examples.io.threed.obj.OBJWriter;
import org.junit.Assert;
import org.junit.Test;

public class OBJWriterTest {
    private static final double TEST_EPS = 1.0E-10;
    private static final DoublePrecisionContext TEST_PRECISION = new EpsilonDoublePrecisionContext(1.0E-10);

    @Test
    public void testDefaults() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            Assert.assertEquals((Object)"\n", (Object)meshWriter.getLineSeparator());
            Assert.assertEquals((long)6L, (long)meshWriter.getDecimalFormat().getMaximumFractionDigits());
        }
    }

    @Test
    public void testClose_calledMultipleTimes() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.close();
            meshWriter.close();
        }
    }

    @Test
    public void testSetLineSeparator() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.setLineSeparator("\r\n");
            meshWriter.writeComment("line 1");
            meshWriter.writeComment("line 2");
            meshWriter.writeVertex(Vector3D.ZERO);
        }
        Assert.assertEquals((Object)"# line 1\r\n# line 2\r\nv 0 0 0\r\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testSetDecimalFormat() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.setDecimalFormat(new DecimalFormat("00.0"));
            meshWriter.writeVertex(Vector3D.of((double)1.0, (double)2.0, (double)3.0));
        }
        Assert.assertEquals((Object)"v 01.0 02.0 03.0\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteComment() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeComment("test");
            meshWriter.writeComment(" a\r\n multi-line\ncomment");
        }
        Assert.assertEquals((Object)"# test\n#  a\n#  multi-line\n# comment\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteObjectName() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeObjectName("test-object");
        }
        Assert.assertEquals((Object)"o test-object\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteGroupName() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeGroupName("test-group");
        }
        Assert.assertEquals((Object)"g test-group\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteVertex() throws IOException {
        int index2;
        int index1;
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.getDecimalFormat().setMaximumFractionDigits(1);
            index1 = meshWriter.writeVertex(Vector3D.of((double)1.09, (double)2.1, (double)3.005));
            index2 = meshWriter.writeVertex(Vector3D.of((double)0.06, (double)10.0, (double)12.0));
        }
        Assert.assertEquals((long)1L, (long)index1);
        Assert.assertEquals((long)2L, (long)index2);
        Assert.assertEquals((Object)"v 1.1 2.1 3\nv 0.1 10 12\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteFace() throws IOException {
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeVertex(Vector3D.ZERO);
            meshWriter.writeVertex(Vector3D.of((double)1.0, (double)0.0, (double)0.0));
            meshWriter.writeVertex(Vector3D.of((double)1.0, (double)1.0, (double)0.0));
            meshWriter.writeVertex(Vector3D.of((double)0.0, (double)1.0, (double)0.0));
            meshWriter.writeFace(new int[]{1, 2, 3});
            meshWriter.writeFace(new int[]{1, 2, 3, -1});
        }
        Assert.assertEquals((Object)"v 0 0 0\nv 1 0 0\nv 1 1 0\nv 0 1 0\nf 1 2 3\nf 1 2 3 -1\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteFace_invalidVertexNumber() throws IOException {
        StringWriter writer = new StringWriter();
        GeometryTestUtils.assertThrows(() -> {
            try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
                meshWriter.writeFace(new int[]{1, 2});
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }, IllegalArgumentException.class, (String)"Face must have more than 3 vertices; found 2");
    }

    @Test
    public void testWriteMesh() throws IOException {
        SimpleTriangleMesh mesh = SimpleTriangleMesh.builder((DoublePrecisionContext)TEST_PRECISION).addFaceUsingVertices(Vector3D.ZERO, Vector3D.of((double)1.0, (double)0.0, (double)0.0), Vector3D.of((double)0.0, (double)1.0, (double)0.0)).addFaceUsingVertices(Vector3D.ZERO, Vector3D.of((double)1.0, (double)0.0, (double)0.0), Vector3D.of((double)0.0, (double)0.0, (double)1.0)).build();
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeMesh((Mesh)mesh);
        }
        Assert.assertEquals((Object)"v 0 0 0\nv 1 0 0\nv 0 1 0\nv 0 0 1\nf 1 2 3\nf 1 2 4\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteBoundaries_meshArgument() throws IOException {
        SimpleTriangleMesh mesh = SimpleTriangleMesh.builder((DoublePrecisionContext)TEST_PRECISION).addFaceUsingVertices(Vector3D.ZERO, Vector3D.of((double)1.0, (double)0.0, (double)0.0), Vector3D.of((double)0.0, (double)1.0, (double)0.0)).addFaceUsingVertices(Vector3D.ZERO, Vector3D.of((double)1.0, (double)0.0, (double)0.0), Vector3D.of((double)0.0, (double)0.0, (double)1.0)).build();
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeBoundaries((BoundarySource3D)mesh);
        }
        Assert.assertEquals((Object)"v 0 0 0\nv 1 0 0\nv 0 1 0\nv 0 0 1\nf 1 2 3\nf 1 2 4\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteBoundaries_nonMeshArgument() throws IOException {
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION), Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)0.0, (double)1.0), (DoublePrecisionContext)TEST_PRECISION)});
        StringWriter writer = new StringWriter();
        try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
            meshWriter.writeBoundaries(src);
        }
        Assert.assertEquals((Object)"v 0 0 0\nv 1 0 0\nv 0 1 0\nf 1 2 3\nv 0 0 0\nv 1 0 0\nv 0 0 1\nf 4 5 6\n", (Object)writer.getBuffer().toString());
    }

    @Test
    public void testWriteBoundaries_infiniteBoundary() throws IOException {
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION), Planes.fromPointAndNormal((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.Unit.PLUS_Z, (DoublePrecisionContext)TEST_PRECISION).span()});
        StringWriter writer = new StringWriter();
        GeometryTestUtils.assertThrows(() -> {
            try (OBJWriter meshWriter = new OBJWriter((Writer)writer);){
                meshWriter.writeBoundaries(src);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }, IllegalArgumentException.class, (Pattern)Pattern.compile("^OBJ input geometry cannot be infinite: .*"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToFile_boundaries() throws IOException {
        RegionBSPTree3D box = Parallelepiped.unitCube((DoublePrecisionContext)TEST_PRECISION).toTree();
        RegionBSPTree3D sphere = Sphere.from((Vector3D)Vector3D.ZERO, (double)0.6, (DoublePrecisionContext)TEST_PRECISION).toTree(3);
        RegionBSPTree3D result = RegionBSPTree3D.empty();
        result.difference((AbstractRegionBSPTree)box, (AbstractRegionBSPTree)sphere);
        TriangleMesh mesh = result.toTriangleMesh(TEST_PRECISION);
        Path out = Files.createTempFile("objTest", ".obj", new FileAttribute[0]);
        try (OBJWriter writer = new OBJWriter(out.toFile());){
            writer.writeComment("A test obj file\nWritten by " + OBJReaderTest.class.getName());
            writer.writeBoundaries((BoundarySource3D)mesh);
        }
        finally {
            Files.delete(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToFile_mesh() throws IOException {
        RegionBSPTree3D box = Parallelepiped.unitCube((DoublePrecisionContext)TEST_PRECISION).toTree();
        RegionBSPTree3D sphere = Sphere.from((Vector3D)Vector3D.ZERO, (double)0.6, (DoublePrecisionContext)TEST_PRECISION).toTree(3);
        RegionBSPTree3D result = RegionBSPTree3D.empty();
        result.difference((AbstractRegionBSPTree)box, (AbstractRegionBSPTree)sphere);
        Path out = Files.createTempFile("objTest", ".obj", new FileAttribute[0]);
        try (OBJWriter writer = new OBJWriter(out.toFile());){
            writer.writeComment("A test obj file\nWritten by " + OBJReaderTest.class.getName());
            writer.writeBoundaries((BoundarySource3D)result);
        }
        finally {
            Files.delete(out);
        }
    }
}

