/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed.obj;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import org.apache.commons.geometry.core.GeometryTestUtils;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.EuclideanTestUtils;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.examples.io.threed.obj.OBJReader;
import org.junit.Assert;
import org.junit.Test;

public class OBJReaderTest {
    private static final double TEST_EPS = 1.0E-10;
    private static final DoublePrecisionContext TEST_PRECISION = new EpsilonDoublePrecisionContext(1.0E-10);
    private static final String CUBE_MINUS_SPHERE_MODEL = "/models/cube-minus-sphere.obj";
    private static final int CUBE_MINUS_SPHERE_VERTICES = 1688;
    private static final int CUBE_MINUS_SPHERE_FACES = 728;
    private OBJReader reader = new OBJReader();

    @Test
    public void testReadMesh_emptyInput() throws Exception {
        TriangleMesh mesh = this.reader.readTriangleMesh((Reader)new StringReader(""), TEST_PRECISION);
        Assert.assertEquals((long)0L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)0L, (long)mesh.getFaceCount());
    }

    @Test
    public void testReadMesh_mixedVertexIndexTypesAndWhitespace() throws Exception {
        String input = "#some comments  \n\r\n \n # some other comments\nv 0.0 0.0 0.0\nv 1e-1 0 0 \r\n v 0 1 0\n\tv\t0 0 1\r\nf 1 2 3\n f    -1   -2\t-3";
        TriangleMesh mesh = this.reader.readTriangleMesh((Reader)new StringReader(input), TEST_PRECISION);
        Assert.assertEquals((long)4L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)2L, (long)mesh.getFaceCount());
        Triangle3D t0 = ((TriangleMesh.Face)mesh.getFace(0)).getPolygon();
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)t0.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.1, (double)0.0, (double)0.0), (Vector3D)t0.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (Vector3D)t0.getPoint3(), (double)1.0E-10);
        Triangle3D t1 = ((TriangleMesh.Face)mesh.getFace(1)).getPolygon();
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)0.0, (double)1.0), (Vector3D)t1.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (Vector3D)t1.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.1, (double)0.0, (double)0.0), (Vector3D)t1.getPoint3(), (double)1.0E-10);
    }

    @Test
    public void testReadMesh_multipleFaceIndices_usesTriangleFan() throws Exception {
        String input = "v 0 0 0\nv 1 0 0\nv 1 1 0\nv 0.5 1.5 0\nv 0 1 0\nf 1 2 3 -2 -1\n";
        TriangleMesh mesh = this.reader.readTriangleMesh((Reader)new StringReader(input), TEST_PRECISION);
        Assert.assertEquals((long)5L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)3L, (long)mesh.getFaceCount());
        Triangle3D t0 = ((TriangleMesh.Face)mesh.getFace(0)).getPolygon();
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)t0.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)t0.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)1.0, (double)1.0, (double)0.0), (Vector3D)t0.getPoint3(), (double)1.0E-10);
        Triangle3D t1 = ((TriangleMesh.Face)mesh.getFace(1)).getPolygon();
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)t1.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)1.0, (double)1.0, (double)0.0), (Vector3D)t1.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.5, (double)1.5, (double)0.0), (Vector3D)t1.getPoint3(), (double)1.0E-10);
        Triangle3D t2 = ((TriangleMesh.Face)mesh.getFace(2)).getPolygon();
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)t2.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.5, (double)1.5, (double)0.0), (Vector3D)t2.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (Vector3D)t2.getPoint3(), (double)1.0E-10);
    }

    @Test
    public void testReadMesh_ignoresUnsupportedContent() throws Exception {
        String input = "mtllib abc.mtl\nnope\nv 0 0 0\nv 1 0 0\nv 0 1 0\nf 1/10/20 2//40 3//\n";
        TriangleMesh mesh = this.reader.readTriangleMesh((Reader)new StringReader(input), TEST_PRECISION);
        Assert.assertEquals((long)3L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)1L, (long)mesh.getFaceCount());
        Triangle3D t0 = ((TriangleMesh.Face)mesh.getFace(0)).getPolygon();
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)t0.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)t0.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (Vector3D)t0.getPoint3(), (double)1.0E-10);
    }

    @Test
    public void testReadMesh_invalidVertexDefinition() throws Exception {
        String badNumber = "v abc 0 0\nv 1 0 0\nv 0 1 0\nf 1 2 3\n";
        String notEnoughVertices = "v 0 0\nv 1 0 0\nv 0 1 0\nf 1 2 3\n";
        GeometryTestUtils.assertThrows(() -> {
            try {
                this.reader.readTriangleMesh((Reader)new StringReader(badNumber), TEST_PRECISION);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }, NumberFormatException.class);
        GeometryTestUtils.assertThrows(() -> {
            try {
                this.reader.readTriangleMesh((Reader)new StringReader(notEnoughVertices), TEST_PRECISION);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }, IllegalArgumentException.class, (String)"Invalid vertex definition: at least 3 fields required but found only 2");
    }

    @Test
    public void testReadMesh_invalidFaceDefinition() throws Exception {
        String badNumber = "v 0 0 0\nv 1 0 0\nv 0 1 0\nf 1 abc 3\n";
        String notEnoughIndices = "v 0 0 0\nv 1 0 0\nv 0 1 0\nf 1 2\n";
        GeometryTestUtils.assertThrows(() -> {
            try {
                this.reader.readTriangleMesh((Reader)new StringReader(badNumber), TEST_PRECISION);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }, NumberFormatException.class);
        GeometryTestUtils.assertThrows(() -> {
            try {
                this.reader.readTriangleMesh((Reader)new StringReader(notEnoughIndices), TEST_PRECISION);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }, IllegalArgumentException.class, (String)"Invalid face definition: at least 3 fields required but found only 2");
    }

    @Test
    public void testReadMesh_cubeMinusSphereFile() throws Exception {
        URL url = this.getClass().getResource(CUBE_MINUS_SPHERE_MODEL);
        File file = new File(url.toURI());
        TriangleMesh mesh = this.reader.readTriangleMesh(file, TEST_PRECISION);
        Assert.assertEquals((long)1688L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)728L, (long)mesh.getFaceCount());
        RegionBSPTree3D tree = RegionBSPTree3D.partitionedRegionBuilder().insertAxisAlignedGrid(mesh.getBounds(), 1, TEST_PRECISION).insertBoundaries((BoundarySource3D)mesh).build();
        double eps = 1.0E-5;
        Assert.assertEquals((double)0.11509505362599505, (double)tree.getSize(), (double)eps);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)((Vector3D)tree.getCentroid()), (double)1.0E-10);
    }

    @Test
    public void testReadMesh_cubeMinusSphereUrl() throws IOException {
        URL url = this.getClass().getResource(CUBE_MINUS_SPHERE_MODEL);
        TriangleMesh mesh = this.reader.readTriangleMesh(url, TEST_PRECISION);
        Assert.assertEquals((long)1688L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)728L, (long)mesh.getFaceCount());
    }
}

