/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed.obj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.geometry.core.GeometryTestUtils;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.examples.io.threed.obj.OBJModelIOHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class OBJModelIOHandlerTest {
    private static final double TEST_EPS = 1.0E-10;
    private static final DoublePrecisionContext TEST_PRECISION = new EpsilonDoublePrecisionContext(1.0E-10);
    private static final String CUBE_MINUS_SPHERE_MODEL = "/models/cube-minus-sphere.obj";
    private static final int CUBE_MINUS_SPHERE_VERTICES = 1688;
    private static final int CUBE_MINUS_SPHERE_FACES = 728;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private OBJModelIOHandler handler = new OBJModelIOHandler();

    @Test
    public void testHandlesType() {
        Assert.assertFalse((boolean)this.handler.handlesType(null));
        Assert.assertFalse((boolean)this.handler.handlesType(""));
        Assert.assertFalse((boolean)this.handler.handlesType(" "));
        Assert.assertFalse((boolean)this.handler.handlesType("abc"));
        Assert.assertFalse((boolean)this.handler.handlesType("stl"));
        Assert.assertTrue((boolean)this.handler.handlesType("obj"));
        Assert.assertTrue((boolean)this.handler.handlesType("OBJ"));
        Assert.assertTrue((boolean)this.handler.handlesType("oBj"));
    }

    @Test
    public void testRead_fromFile() throws Exception {
        BoundarySource3D src = this.handler.read("obj", OBJModelIOHandlerTest.cubeMinusSphereFile(), TEST_PRECISION);
        TriangleMesh mesh = (TriangleMesh)src;
        Assert.assertEquals((long)1688L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)728L, (long)mesh.getFaceCount());
    }

    @Test
    public void testRead_fromFile_unsupportedType() throws Exception {
        File file = OBJModelIOHandlerTest.cubeMinusSphereFile();
        GeometryTestUtils.assertThrows(() -> this.handler.read("stl", file, TEST_PRECISION), IllegalArgumentException.class, (String)"File type is not supported by this handler: stl");
    }

    @Test
    public void testRead_fromFile_ioException() throws Exception {
        File file = new File("doesnotexist.obj");
        GeometryTestUtils.assertThrows(() -> this.handler.read("obj", file, TEST_PRECISION), UncheckedIOException.class);
    }

    @Test
    public void testRead_fromStream() throws Exception {
        BoundarySource3D src;
        try (InputStream in = Files.newInputStream(OBJModelIOHandlerTest.cubeMinusSphereFile().toPath(), new OpenOption[0]);){
            src = this.handler.read("obj", OBJModelIOHandlerTest.cubeMinusSphereFile(), TEST_PRECISION);
        }
        TriangleMesh mesh = (TriangleMesh)src;
        Assert.assertEquals((long)1688L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)728L, (long)mesh.getFaceCount());
    }

    @Test
    public void testRead_fromStream_unsupportedType() throws Exception {
        File file = OBJModelIOHandlerTest.cubeMinusSphereFile();
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            GeometryTestUtils.assertThrows(() -> this.handler.read("stl", in, TEST_PRECISION), IllegalArgumentException.class, (String)"File type is not supported by this handler: stl");
        }
    }

    @Test
    public void testRead_fromStream_ioException() throws Exception {
        GeometryTestUtils.assertThrows(() -> this.handler.read("obj", (InputStream)new FailingInputStream(), TEST_PRECISION), UncheckedIOException.class, (String)"IOException: test");
    }

    @Test
    public void testWrite_toFile() throws Exception {
        File out = this.tempFolder.newFile("out.obj");
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        this.handler.write(src, "OBJ", out);
        TriangleMesh mesh = (TriangleMesh)this.handler.read("obj", out, TEST_PRECISION);
        Assert.assertEquals((long)3L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)1L, (long)mesh.getFaceCount());
    }

    @Test
    public void testWrite_toFile_unsupportedFormat() throws Exception {
        File out = this.tempFolder.newFile("out.obj");
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        GeometryTestUtils.assertThrows(() -> this.handler.write(src, "stl", out), IllegalArgumentException.class, (String)"File type is not supported by this handler: stl");
    }

    @Test
    public void testWrite_toFile_ioException() throws Exception {
        File out = this.tempFolder.newFolder("notafile");
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        GeometryTestUtils.assertThrows(() -> this.handler.write(src, "OBJ", out), UncheckedIOException.class);
    }

    @Test
    public void testWrite_toStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        this.handler.write(src, "OBJ", (OutputStream)out);
        TriangleMesh mesh = (TriangleMesh)this.handler.read("obj", (InputStream)new ByteArrayInputStream(out.toByteArray()), TEST_PRECISION);
        Assert.assertEquals((long)3L, (long)mesh.getVertexCount());
        Assert.assertEquals((long)1L, (long)mesh.getFaceCount());
    }

    @Test
    public void testWrite_toStream_unsupportedFormat() throws Exception {
        File file = this.tempFolder.newFile("out.obj");
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            GeometryTestUtils.assertThrows(() -> this.handler.write(src, "stl", out), IllegalArgumentException.class, (String)"File type is not supported by this handler: stl");
        }
    }

    @Test
    public void testWrite_toStream_ioException() throws Exception {
        BoundarySource3D src = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        GeometryTestUtils.assertThrows(() -> this.handler.write(src, "OBJ", (OutputStream)new FailingOutputStream()), UncheckedIOException.class, (String)"IOException: test");
    }

    private static File cubeMinusSphereFile() throws Exception {
        URL url = OBJModelIOHandlerTest.class.getResource(CUBE_MINUS_SPHERE_MODEL);
        return new File(url.toURI());
    }

    private static final class FailingOutputStream
    extends OutputStream {
        private FailingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("test");
        }
    }

    private static final class FailingInputStream
    extends InputStream {
        private FailingInputStream() {
        }

        @Override
        public int read() throws IOException {
            throw new IOException("test");
        }
    }
}

