/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.EuclideanTestUtils;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.examples.io.threed.DefaultModelIOHandlerRegistry;
import org.apache.commons.geometry.examples.io.threed.ModelIO;
import org.apache.commons.geometry.examples.io.threed.ModelIOHandlerRegistry;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ModelIOTest {
    private static final double TEST_EPS = 1.0E-10;
    private static final DoublePrecisionContext TEST_PRECISION = new EpsilonDoublePrecisionContext(1.0E-10);
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testGetHandler() {
        ModelIOHandlerRegistry registry = ModelIO.getModelIOHandlerRegistry();
        Assert.assertTrue((boolean)(registry instanceof DefaultModelIOHandlerRegistry));
        Assert.assertSame((Object)registry, (Object)ModelIO.getModelIOHandlerRegistry());
    }

    @Test
    public void testWriteRead_typeFromFileExtension() throws IOException {
        this.checkWriteRead(model -> {
            File file = new File(this.tempFolder.getRoot(), "model.obj");
            ModelIO.write((BoundarySource3D)model, (File)file);
            return ModelIO.read((File)file, (DoublePrecisionContext)TEST_PRECISION);
        });
    }

    @Test
    public void testWriteRead_typeAndFile() throws IOException {
        this.checkWriteRead(model -> {
            File file = new File(this.tempFolder.getRoot(), "objmodel");
            ModelIO.write((BoundarySource3D)model, (String)"OBJ", (File)file);
            return ModelIO.read((String)"obj", (File)file, (DoublePrecisionContext)TEST_PRECISION);
        });
    }

    @Test
    public void testWriteRead_typeAndStream() throws IOException {
        this.checkWriteRead(model -> {
            File file = new File(this.tempFolder.getRoot(), "objmodel");
            try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                ModelIO.write((BoundarySource3D)model, (String)"OBJ", (OutputStream)out);
            }
            var4_4 = null;
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                BoundarySource3D boundarySource3D = ModelIO.read((String)"OBJ", (InputStream)in, (DoublePrecisionContext)TEST_PRECISION);
                return boundarySource3D;
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
        });
    }

    private void checkWriteRead(ModelIOFunction fn) throws IOException {
        BoundarySource3D model = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        BoundarySource3D result = fn.apply(model);
        List tris = result.triangleStream().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)tris.size());
        Triangle3D tri = (Triangle3D)tris.get(0);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)tri.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)tri.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (Vector3D)tri.getPoint3(), (double)1.0E-10);
    }

    @FunctionalInterface
    private static interface ModelIOFunction {
        public BoundarySource3D apply(BoundarySource3D var1) throws IOException;
    }
}

