/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.geometry.core.GeometryTestUtils;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.examples.io.threed.ModelIOHandler;
import org.apache.commons.geometry.examples.io.threed.ModelIOHandlerRegistry;
import org.junit.Assert;
import org.junit.Test;

public class ModelIOHandlerRegistryTest {
    private static final double TEST_EPS = 1.0E-10;
    private static final DoublePrecisionContext TEST_PRECISION = new EpsilonDoublePrecisionContext(1.0E-10);
    private static final BoundarySource3D SRC_A = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[0]);
    private static final BoundarySource3D SRC_B = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[0]);
    private ModelIOHandlerRegistry registry = new ModelIOHandlerRegistry();

    @Test
    public void testGetSetHandlers() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        List<ModelIOHandler> handlers = Arrays.asList(handlerA, handlerB);
        this.registry.setHandlers(handlers);
        List resultHandlers = this.registry.getHandlers();
        Assert.assertNotSame(handlers, (Object)resultHandlers);
        Assert.assertEquals((long)2L, (long)resultHandlers.size());
        Assert.assertSame((Object)handlerA, resultHandlers.get(0));
        Assert.assertSame((Object)handlerB, resultHandlers.get(1));
    }

    @Test
    public void testSetHandlers_null() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        this.registry.setHandlers(null);
        Assert.assertEquals((long)0L, (long)this.registry.getHandlers().size());
    }

    @Test
    public void testGetHandlerForType() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        Assert.assertSame((Object)handlerA, (Object)this.registry.getHandlerForType("a"));
        Assert.assertSame((Object)handlerB, (Object)this.registry.getHandlerForType("b"));
        Assert.assertNull((Object)this.registry.getHandlerForType(null));
        Assert.assertNull((Object)this.registry.getHandlerForType(""));
        Assert.assertNull((Object)this.registry.getHandlerForType(" "));
        Assert.assertNull((Object)this.registry.getHandlerForType("nope"));
    }

    @Test
    public void testHandlesType() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        Assert.assertTrue((boolean)this.registry.handlesType("a"));
        Assert.assertTrue((boolean)this.registry.handlesType("b"));
        Assert.assertFalse((boolean)this.registry.handlesType(null));
        Assert.assertFalse((boolean)this.registry.handlesType(""));
        Assert.assertFalse((boolean)this.registry.handlesType(" "));
        Assert.assertFalse((boolean)this.registry.handlesType("nope"));
    }

    @Test
    public void testRead_typeFromFileExtension() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        File file = new File("file.B");
        BoundarySource3D src = this.registry.read(file, TEST_PRECISION);
        Assert.assertSame((Object)SRC_B, (Object)src);
    }

    @Test
    public void testRead_typeFromFileExtension_unknownType() {
        File file = new File("file.B");
        GeometryTestUtils.assertThrows(() -> this.registry.read(file, TEST_PRECISION), IllegalArgumentException.class, (String)"No handler found for type \"b\"");
    }

    @Test
    public void testRead_typeFromFileExtension_noFileExtension() {
        File file = new File("file");
        GeometryTestUtils.assertThrows(() -> this.registry.read(file, TEST_PRECISION), IllegalArgumentException.class, (String)"Cannot determine target file type: \"file\" does not have a file extension");
    }

    @Test
    public void testRead_typeAndFile() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        BoundarySource3D src = this.registry.read("a", new File("file"), TEST_PRECISION);
        Assert.assertSame((Object)SRC_A, (Object)src);
    }

    @Test
    public void testRead_typeAndFile_unknownType() {
        File file = new File("file");
        GeometryTestUtils.assertThrows(() -> this.registry.read("nope", file, TEST_PRECISION), IllegalArgumentException.class, (String)"No handler found for type \"nope\"");
    }

    @Test
    public void testRead_typeAndInputStream() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        BoundarySource3D src = this.registry.read("a", (InputStream)new ByteArrayInputStream(new byte[0]), TEST_PRECISION);
        Assert.assertSame((Object)SRC_A, (Object)src);
    }

    @Test
    public void testRead_typeAndInputStream_unknownType() {
        GeometryTestUtils.assertThrows(() -> this.registry.read("nope", (InputStream)new ByteArrayInputStream(new byte[0]), TEST_PRECISION), IllegalArgumentException.class, (String)"No handler found for type \"nope\"");
    }

    @Test
    public void testWrite_typeFromFileExtension() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        File file = new File("file.B");
        this.registry.write(SRC_B, file);
        Assert.assertNull((Object)handlerA.outputBoundarySrc);
        Assert.assertSame((Object)SRC_B, (Object)handlerB.outputBoundarySrc);
    }

    @Test
    public void testWrite_typeFromFileExtension_unknownType() {
        File file = new File("file.B");
        GeometryTestUtils.assertThrows(() -> this.registry.write(SRC_A, file), IllegalArgumentException.class, (String)"No handler found for type \"b\"");
    }

    @Test
    public void testWrite_typeFromFileExtension_noFileExtension() {
        File file = new File("file");
        GeometryTestUtils.assertThrows(() -> this.registry.write(SRC_A, file), IllegalArgumentException.class, (String)"Cannot determine target file type: \"file\" does not have a file extension");
    }

    @Test
    public void testWrite_typeAndFile() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        File file = new File("file.B");
        this.registry.write(SRC_B, "a", file);
        Assert.assertSame((Object)SRC_B, (Object)handlerA.outputBoundarySrc);
        Assert.assertNull((Object)handlerB.outputBoundarySrc);
    }

    @Test
    public void testWrite_typeAndFile_unknownType() {
        File file = new File("file");
        GeometryTestUtils.assertThrows(() -> this.registry.write(SRC_A, "nope", file), IllegalArgumentException.class, (String)"No handler found for type \"nope\"");
    }

    @Test
    public void testWrite_typeAndOutputStream() {
        StubHandler handlerA = new StubHandler("a", SRC_A);
        StubHandler handlerB = new StubHandler("b", SRC_B);
        this.registry.setHandlers(Arrays.asList(handlerA, handlerB));
        this.registry.write(SRC_B, "a", (OutputStream)new ByteArrayOutputStream());
        Assert.assertSame((Object)SRC_B, (Object)handlerA.outputBoundarySrc);
        Assert.assertNull((Object)handlerB.outputBoundarySrc);
    }

    @Test
    public void testWrite_typeAndOutputStream_unknownType() {
        GeometryTestUtils.assertThrows(() -> this.registry.write(SRC_A, "nope", (OutputStream)new ByteArrayOutputStream()), IllegalArgumentException.class, (String)"No handler found for type \"nope\"");
    }

    private static final class StubHandler
    implements ModelIOHandler {
        private final String handlerType;
        private final BoundarySource3D boundarySrc;
        private BoundarySource3D outputBoundarySrc;

        StubHandler(String type, BoundarySource3D boundarySrc) {
            this.handlerType = type;
            this.boundarySrc = boundarySrc;
        }

        public boolean handlesType(String type) {
            return this.handlerType.equals(type);
        }

        public BoundarySource3D read(String type, File in, DoublePrecisionContext precision) {
            return this.boundarySrc;
        }

        public BoundarySource3D read(String type, InputStream in, DoublePrecisionContext precision) {
            return this.boundarySrc;
        }

        public void write(BoundarySource3D model, String type, File out) {
            this.outputBoundarySrc = model;
        }

        public void write(BoundarySource3D model, String type, OutputStream out) {
            this.outputBoundarySrc = model;
        }
    }
}

