/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.EuclideanTestUtils;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.examples.io.threed.DefaultModelIOHandlerRegistry;
import org.junit.Assert;
import org.junit.Test;

public class DefaultModelIOHandlerRegistryTest {
    private static final double TEST_EPS = 1.0E-10;
    private static final DoublePrecisionContext TEST_PRECISION = new EpsilonDoublePrecisionContext(1.0E-10);
    private DefaultModelIOHandlerRegistry registry = new DefaultModelIOHandlerRegistry();

    @Test
    public void testDefaultHandlers() {
        List handlers = this.registry.getHandlers();
        Assert.assertEquals((long)1L, (long)handlers.size());
    }

    @Test
    public void testSupportedTypes() {
        Assert.assertTrue((boolean)this.registry.handlesType("obj"));
        Assert.assertTrue((boolean)this.registry.handlesType("OBJ"));
    }

    @Test
    public void testReadWrite_supportedTypes() {
        this.checkWriteRead("obj");
    }

    private void checkWriteRead(String type) {
        BoundarySource3D model = BoundarySource3D.from((PlaneConvexSubset[])new PlaneConvexSubset[]{Planes.triangleFromVertices((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (DoublePrecisionContext)TEST_PRECISION)});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.registry.write(model, type, (OutputStream)out);
        BoundarySource3D result = this.registry.read(type, (InputStream)new ByteArrayInputStream(out.toByteArray()), TEST_PRECISION);
        List tris = result.triangleStream().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)tris.size());
        Triangle3D tri = (Triangle3D)tris.get(0);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.ZERO, (Vector3D)tri.getPoint1(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)1.0, (double)0.0, (double)0.0), (Vector3D)tri.getPoint2(), (double)1.0E-10);
        EuclideanTestUtils.assertCoordinatesEqual((Vector3D)Vector3D.of((double)0.0, (double)1.0, (double)0.0), (Vector3D)tri.getPoint3(), (double)1.0E-10);
    }
}

