/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.enclosing.euclidean.twod;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.enclosing.EnclosingBall;
import org.apache.commons.geometry.enclosing.SupportBallGenerator;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.fraction.BigFraction;

public class DiskGenerator
implements SupportBallGenerator<Vector2D> {
    @Override
    public EnclosingBall<Vector2D> ballOnSupport(List<Vector2D> support) {
        if (support.isEmpty()) {
            return new EnclosingBall<Vector2D>(Vector2D.ZERO, Double.NEGATIVE_INFINITY, Collections.emptyList());
        }
        Vector2D vA = support.get(0);
        if (support.size() < 2) {
            return new EnclosingBall<Vector2D>(vA, 0.0, Collections.singletonList(vA));
        }
        Vector2D vB = support.get(1);
        if (support.size() < 3) {
            return new EnclosingBall<Vector2D>(Vector2D.linearCombination((double)0.5, (Vector2D)vA, (double)0.5, (Vector2D)vB), 0.5 * vA.distance(vB), Arrays.asList(vA, vB));
        }
        Vector2D vC = support.get(2);
        BigFraction[] c2 = new BigFraction[]{BigFraction.from((double)vA.getX()), BigFraction.from((double)vB.getX()), BigFraction.from((double)vC.getX())};
        BigFraction[] c3 = new BigFraction[]{BigFraction.from((double)vA.getY()), BigFraction.from((double)vB.getY()), BigFraction.from((double)vC.getY())};
        BigFraction[] c1 = new BigFraction[]{c2[0].multiply(c2[0]).add(c3[0].multiply(c3[0])), c2[1].multiply(c2[1]).add(c3[1].multiply(c3[1])), c2[2].multiply(c2[2]).add(c3[2].multiply(c3[2]))};
        BigFraction twoM11 = this.minor(c2, c3).multiply(2);
        BigFraction m12 = this.minor(c1, c3);
        BigFraction m13 = this.minor(c1, c2);
        BigFraction centerX = m12.divide(twoM11);
        BigFraction centerY = m13.divide(twoM11).negate();
        BigFraction dx = c2[0].subtract(centerX);
        BigFraction dy = c3[0].subtract(centerY);
        BigFraction r2 = dx.multiply(dx).add(dy.multiply(dy));
        return new EnclosingBall<Vector2D>(Vector2D.of((double)centerX.doubleValue(), (double)centerY.doubleValue()), Math.sqrt(r2.doubleValue()), Arrays.asList(vA, vB, vC));
    }

    private BigFraction minor(BigFraction[] c1, BigFraction[] c2) {
        return c2[0].multiply(c1[2].subtract(c1[1])).add(c2[1].multiply(c1[0].subtract(c1[2]))).add(c2[2].multiply(c1[1].subtract(c1[0])));
    }
}

