/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.enclosing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;

public class EnclosingBall<P extends Point<P>> {
    private final P center;
    private final double radius;
    private final List<P> support;

    public EnclosingBall(P center, double radius, Collection<P> support) {
        this.center = center;
        this.radius = radius;
        this.support = Collections.unmodifiableList(new ArrayList<P>(support));
    }

    public P getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public List<P> getSupport() {
        return this.support;
    }

    public int getSupportSize() {
        return this.support.size();
    }

    public boolean contains(P point) {
        return point.distance(this.center) <= this.radius;
    }

    public boolean contains(P point, DoublePrecisionContext precision) {
        return precision.lte(point.distance(this.center), this.radius);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[center= ").append(this.getCenter()).append(", radius= ").append(this.getRadius()).append(']');
        return sb.toString();
    }
}

