/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.ConnectionPoolDataSourceProxy;
import org.apache.commons.dbcp2.datasources.KeyedCPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKeyedCPDSConnectionFactory {
    protected ConnectionPoolDataSourceProxy cpds = null;

    @Before
    public void setUp() throws Exception {
        this.cpds = new ConnectionPoolDataSourceProxy((ConnectionPoolDataSource)new DriverAdapterCPDS());
        DriverAdapterCPDS delegate = (DriverAdapterCPDS)this.cpds.getDelegate();
        delegate.setDriver("org.apache.commons.dbcp2.TesterDriver");
        delegate.setUrl("jdbc:apache:commons:testdriver");
        delegate.setUser("username");
        delegate.setPassword("password");
    }

    @Test
    public void testSharedPoolDSDestroyOnReturn() throws Exception {
        SharedPoolDataSource ds = new SharedPoolDataSource();
        ds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.cpds);
        ds.setMaxTotal(10);
        ds.setDefaultMaxWaitMillis(50L);
        ds.setDefaultMaxIdle(2);
        Connection conn1 = ds.getConnection("username", "password");
        Connection conn2 = ds.getConnection("username", "password");
        Connection conn3 = ds.getConnection("username", "password");
        Assert.assertEquals((long)3L, (long)ds.getNumActive());
        conn1.close();
        Assert.assertEquals((long)1L, (long)ds.getNumIdle());
        conn2.close();
        Assert.assertEquals((long)2L, (long)ds.getNumIdle());
        conn3.close();
        Assert.assertEquals((long)2L, (long)ds.getNumIdle());
        ds.close();
    }

    @Test
    public void testConnectionErrorCleanup() throws Exception {
        UserPassKey key = new UserPassKey("username", "password");
        KeyedCPDSConnectionFactory factory = new KeyedCPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, -1, false);
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory);
        factory.setPool((KeyedObjectPool)pool);
        PooledConnection pcon1 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
        Connection con1 = pcon1.getConnection();
        PooledConnection pcon2 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
        Assert.assertEquals((long)2L, (long)pool.getNumActive((Object)key));
        Assert.assertEquals((long)0L, (long)pool.getNumIdle((Object)key));
        PooledConnectionProxy pc = (PooledConnectionProxy)pcon1;
        Assert.assertTrue((boolean)pc.getListeners().contains(factory));
        pc.throwConnectionError();
        Assert.assertEquals((long)1L, (long)pool.getNumActive((Object)key));
        Assert.assertEquals((long)0L, (long)pool.getNumIdle((Object)key));
        pc.throwConnectionError();
        Assert.assertEquals((long)1L, (long)pool.getNumActive((Object)key));
        Assert.assertEquals((long)0L, (long)pool.getNumIdle((Object)key));
        PooledConnection pcon3 = ((PooledConnectionAndInfo)pool.borrowObject((Object)key)).getPooledConnection();
        Assert.assertTrue((!pcon3.equals(pcon1) ? 1 : 0) != 0);
        Assert.assertTrue((!pc.getListeners().contains(factory) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)pool.getNumActive((Object)key));
        Assert.assertEquals((long)0L, (long)pool.getNumIdle((Object)key));
        pcon2.getConnection().close();
        pcon3.getConnection().close();
        Assert.assertEquals((long)2L, (long)pool.getNumIdle((Object)key));
        Assert.assertEquals((long)0L, (long)pool.getNumActive((Object)key));
        try {
            pc.getConnection();
            Assert.fail((String)"Expecting SQLException using closed PooledConnection");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        con1.close();
        Assert.assertEquals((long)2L, (long)pool.getNumIdle((Object)key));
        Assert.assertEquals((long)0L, (long)pool.getNumActive((Object)key));
        factory.getPool().clear();
        Assert.assertEquals((long)0L, (long)pool.getNumIdle((Object)key));
    }
}

