/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.Assert;
import org.junit.Test;

public class TestInstanceKeyDataSource {
    @Test
    public void testExceptionOnSetupDefaults() throws Exception {
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser("foo");
        pcds.setPassword("bar");
        pcds.setPoolPreparedStatements(false);
        ThrowOnSetupDefaultsDataSource tds = new ThrowOnSetupDefaultsDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)pcds);
        int numConnections = tds.getNumActive();
        try {
            tds.getConnection("foo", "bar");
            Assert.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)numConnections, (long)tds.getNumActive());
        tds.close();
    }

    private static class ThrowOnSetupDefaultsDataSource
    extends SharedPoolDataSource {
        private static final long serialVersionUID = -448025812063133259L;

        ThrowOnSetupDefaultsDataSource() {
        }

        protected void setupDefaults(Connection con, String username) throws SQLException {
            throw new SQLException("bang!");
        }
    }
}

