/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.ConnectionPoolDataSourceProxy;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCPDSConnectionFactory {
    protected ConnectionPoolDataSourceProxy cpds = null;

    @Before
    public void setUp() throws Exception {
        this.cpds = new ConnectionPoolDataSourceProxy((ConnectionPoolDataSource)new DriverAdapterCPDS());
        DriverAdapterCPDS delegate = (DriverAdapterCPDS)this.cpds.getDelegate();
        delegate.setDriver("org.apache.commons.dbcp2.TesterDriver");
        delegate.setUrl("jdbc:apache:commons:testdriver");
        delegate.setUser("username");
        delegate.setPassword("password");
    }

    @Test
    public void testSharedPoolDSDestroyOnReturn() throws Exception {
        PerUserPoolDataSource ds = new PerUserPoolDataSource();
        ds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.cpds);
        ds.setPerUserMaxTotal("username", Integer.valueOf(10));
        ds.setPerUserMaxWaitMillis("username", Long.valueOf(50L));
        ds.setPerUserMaxIdle("username", Integer.valueOf(2));
        Connection conn1 = ds.getConnection("username", "password");
        Connection conn2 = ds.getConnection("username", "password");
        Connection conn3 = ds.getConnection("username", "password");
        Assert.assertEquals((long)3L, (long)ds.getNumActive("username"));
        conn1.close();
        Assert.assertEquals((long)1L, (long)ds.getNumIdle("username"));
        conn2.close();
        Assert.assertEquals((long)2L, (long)ds.getNumIdle("username"));
        conn3.close();
        Assert.assertEquals((long)2L, (long)ds.getNumIdle("username"));
        ds.close();
    }

    @Test
    public void testConnectionErrorCleanup() throws Exception {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, -1, false, "username", "password");
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool((ObjectPool)pool);
        PooledConnection pcon1 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
        Connection con1 = pcon1.getConnection();
        PooledConnection pcon2 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
        Assert.assertEquals((long)2L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        PooledConnectionProxy pc = (PooledConnectionProxy)pcon1;
        Assert.assertTrue((boolean)pc.getListeners().contains(factory));
        pc.throwConnectionError();
        Assert.assertEquals((long)1L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        pc.throwConnectionError();
        Assert.assertEquals((long)1L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        PooledConnection pcon3 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
        Assert.assertTrue((!pcon3.equals(pcon1) ? 1 : 0) != 0);
        Assert.assertTrue((!pc.getListeners().contains(factory) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        pcon2.getConnection().close();
        pcon3.getConnection().close();
        Assert.assertEquals((long)2L, (long)pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        try {
            pc.getConnection();
            Assert.fail((String)"Expecting SQLException using closed PooledConnection");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        con1.close();
        Assert.assertEquals((long)2L, (long)pool.getNumIdle());
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        factory.getPool().clear();
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
    }
}

